/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.project.MTJNature;
import org.eclipse.mtj.internal.core.util.IJavaProjectVisitor;
import org.eclipse.mtj.internal.core.util.JavaProjectAdapter;
import org.eclipse.mtj.internal.jmunit.util.JMUnitTestsVisitor;

public class JMUnitNature
extends MTJNature {
    private static final String JMUNIT = "JMUnit";
    private static Map<IClasspathEntry, IPath[]> testExclusionPaths;

    public JMUnitNature() {
        if (testExclusionPaths == null) {
            testExclusionPaths = new HashMap<IClasspathEntry, IPath[]>();
        }
    }

    public void configure() throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
        LinkedList<IClasspathEntry> oldEntries = new LinkedList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
        LinkedList<IClasspathEntry> newEntries = new LinkedList<IClasspathEntry>();
        for (IClasspathEntry entry : oldEntries) {
            boolean changed = false;
            switch (entry.getEntryKind()) {
                case 5: {
                    if (!entry.getPath().toString().contains(JMUNIT)) break;
                    newEntries.add(JavaCore.newContainerEntry((IPath)entry.getPath(), (boolean)true));
                    changed = true;
                    break;
                }
                case 3: {
                    ArrayList<IPath> allPaths = new ArrayList<IPath>(Arrays.asList(entry.getExclusionPatterns()));
                    IPath[] testExclusions = testExclusionPaths.get(entry);
                    if (testExclusions != null) {
                        allPaths.removeAll(Arrays.asList(testExclusions));
                    }
                    newEntries.add(JavaCore.newSourceEntry((IPath)entry.getPath(), (IPath[])allPaths.toArray(new IPath[0])));
                    changed = true;
                }
            }
            if (changed) continue;
            newEntries.add(entry);
        }
        IClasspathEntry[] array = newEntries.toArray(new IClasspathEntry[oldEntries.size()]);
        if (!javaProject.hasClasspathCycle(array)) {
            javaProject.setRawClasspath(null, (IProgressMonitor)new NullProgressMonitor());
            javaProject.setRawClasspath(array, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void deconfigure() throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
        LinkedList<IClasspathEntry> oldEntries = new LinkedList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
        LinkedList<IClasspathEntry> newEntries = new LinkedList<IClasspathEntry>();
        JavaProjectAdapter adapter = new JavaProjectAdapter(javaProject);
        JMUnitTestsVisitor visitor = new JMUnitTestsVisitor(javaProject);
        adapter.accept((IJavaProjectVisitor)visitor);
        IPath[] testPaths = visitor.getJMunitTests();
        for (IClasspathEntry entry : oldEntries) {
            boolean changed = false;
            switch (entry.getEntryKind()) {
                case 5: {
                    if (!entry.getPath().toString().contains(JMUNIT)) break;
                    newEntries.add(JavaCore.newContainerEntry((IPath)entry.getPath(), (boolean)false));
                    changed = true;
                    break;
                }
                case 3: {
                    IPath[] exclusionPatterns = entry.getExclusionPatterns();
                    ArrayList<IPath> allPaths = new ArrayList<IPath>();
                    allPaths.addAll(Arrays.asList(exclusionPatterns));
                    allPaths.addAll(Arrays.asList(testPaths));
                    IClasspathEntry newEntry = JavaCore.newSourceEntry((IPath)entry.getPath(), (IPath[])allPaths.toArray(new IPath[0]));
                    newEntries.add(newEntry);
                    if (testPaths.length > 0) {
                        testExclusionPaths.put(newEntry, testPaths);
                    }
                    changed = true;
                }
            }
            if (changed) continue;
            newEntries.add(entry);
        }
        IClasspathEntry[] array = newEntries.toArray(new IClasspathEntry[oldEntries.size()]);
        if (!javaProject.hasClasspathCycle(array)) {
            javaProject.setRawClasspath(null, (IProgressMonitor)new NullProgressMonitor());
            javaProject.setRawClasspath(array, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

