/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.core.api;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.mtj.internal.jmunit.core.api.AbstractTestWriter;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseWriter
extends AbstractTestWriter {
    private Hashtable<String, Integer> overrides = new Hashtable();
    private String test;

    public TestCaseWriter(IType _type, String _name) throws JavaModelException {
        super(_type);
        this.test = _name;
    }

    public void writeCode(IMethod[] _methods, boolean _setup, boolean _teardown, boolean _comment, boolean _stub, boolean _final, IProgressMonitor _monitor) throws JavaModelException {
        this.delimiter = this.type.getTypeRoot().findRecommendedLineSeparator();
        this.writeConstructor(_methods.length, _monitor);
        List<String> methodNames = this.writeTestMethods(_methods, _comment, _stub, _final, _monitor);
        if (_setup) {
            this.writeSetup(_monitor);
        }
        if (_teardown) {
            this.writeTearDown(_monitor);
        }
        this.writeTestMethod(methodNames, _monitor);
    }

    private IMethod writeConstructor(int testNumber, IProgressMonitor _monitor) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        String[] comment = new String[]{"The default constructor. It just transmits the necessary informations to", "the superclass.", "", "@param totalOfTests the total of test methods present in the class.", "@param name this testcase's name."};
        this.writeMethodComment(buffer, comment, this.delimiter);
        String declaration = NLS.bind((String)"public {0}()", (Object)this.type.getElementName());
        String[] body = new String[]{NLS.bind((String)"super({0}, \"{1}\");", (Object[])new String[]{String.valueOf(testNumber), this.test})};
        this.writeMethodDeclaration(buffer, declaration, body, this.delimiter);
        return this.type.createMethod(buffer.toString(), null, false, _monitor);
    }

    private IMethod writeSetup(IProgressMonitor _monitor) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        String[] comment = new String[]{"A empty method used by the framework to initialize the tests. If there's", "5 test methods, the setUp is called 5 times, one for each method. The", "setUp occurs before the method's execution, so the developer can use it", "to any necessary initialization. It's necessary to override it, however.", "", "@throws Throwable anything that the initialization can throw."};
        this.writeMethodComment(buffer, comment, this.delimiter);
        String declaration = "public void setUp() throws Throwable";
        this.writeMethodDeclaration(buffer, declaration, null, this.delimiter);
        return this.type.createMethod(buffer.toString(), null, false, _monitor);
    }

    private IMethod writeTearDown(IProgressMonitor _monitor) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        String[] comment = new String[]{"A empty mehod used by the framework to release resources used by the", "tests. If there's 5 test methods, the tearDown is called 5 times, one for", "each method. The tearDown occurs after the method's execution, so the", "developer can use it to close something used in the test, like a", "nputStream or the RMS. It's necessary to override it, however."};
        this.writeMethodComment(buffer, comment, this.delimiter);
        String declaration = "public void tearDown()";
        this.writeMethodDeclaration(buffer, declaration, null, this.delimiter);
        return this.type.createMethod(buffer.toString(), null, false, _monitor);
    }

    private IMethod writeTestMethod(List<String> methodNames, IProgressMonitor _monitor) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        String[] comment = new String[]{"This method stores all the test methods invocation. The developer must", "implement this method with a switch-case. The cases must start from 0 and", "increase in steps of one until the number declared as the total of tests", "in the constructor, exclusive. For example, if the total is 3, the cases", "must be 0, 1 and 2. In each case, there must be a test method invocation.", "", "@param testNumber the test to be executed.", "@throws Throwable anything that the executed test can throw."};
        this.writeMethodComment(buffer, comment, this.delimiter);
        LinkedList<String> body = new LinkedList<String>();
        int index = 0;
        body.add("switch(testNumber) {");
        for (String methodName : methodNames) {
            body.add(NLS.bind((String)"case {0} :", (Object)String.valueOf(index++)));
            body.add(NLS.bind((String)"{0}();", (Object)methodName));
            body.add("break;");
        }
        body.add("}");
        String declaration = "public void test(int testNumber) throws Throwable";
        this.writeMethodDeclaration(buffer, declaration, body.toArray(new String[body.size()]), this.delimiter);
        return this.type.createMethod(buffer.toString(), null, false, _monitor);
    }

    private List<String> writeTestMethods(IMethod[] _methods, boolean _comment, boolean _stub, boolean _final, IProgressMonitor _monitor) throws JavaModelException {
        LinkedList<String> result = new LinkedList<String>();
        IMethod[] iMethodArray = _methods;
        int n = _methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            String testMethodName = this.resolveMethodName(method.getElementName());
            this.writeTestMethod(method, testMethodName, _comment, _stub, _final, _monitor);
            result.add(testMethodName);
            ++n2;
        }
        return result;
    }

    private IMethod writeTestMethod(IMethod _method, String _testMethodName, boolean _comment, boolean _stub, boolean _final, IProgressMonitor _monitor) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        if (_comment) {
            this.writeMethodComment(buffer, _method);
        }
        String declaration = NLS.bind((String)"public {0} void {1}()", (Object[])new String[]{_final ? "final" : "", _testMethodName});
        String[] body = null;
        body = _stub ? new String[]{"fail(\"Not Yet Implemented.\"); // TODO"} : new String[]{"fail(\"Not Yet Implemented.\");"};
        this.writeMethodDeclaration(buffer, declaration, body, this.delimiter);
        return this.type.createMethod(buffer.toString(), null, false, _monitor);
    }

    private void writeMethodComment(StringBuffer buffer, IMethod _method) throws JavaModelException {
        String[] comments = new String[]{NLS.bind((String)"Test for method: {0}.", (Object)Signature.toString((String)_method.getSignature(), (String)_method.getElementName(), (String[])_method.getParameterNames(), (boolean)true, (boolean)true)), "", NLS.bind((String)"@see {0}#{1}", (Object[])new String[]{_method.getDeclaringType().getFullyQualifiedName(), Signature.toString((String)_method.getSignature(), (String)_method.getElementName(), (String[])_method.getParameterNames(), (boolean)true, (boolean)false)})};
        int i = 0;
        while (i < comments.length) {
            comments[i] = comments[i].replace("/", ".");
            ++i;
        }
        this.writeMethodComment(buffer, comments, this.delimiter);
    }

    private String resolveMethodName(String _name) {
        boolean isOverloaded = false;
        int sequenceNum = 1;
        for (String name : this.overrides.keySet()) {
            if (!name.equals(_name)) continue;
            this.overrides.put(name, sequenceNum += this.overrides.get(name).intValue());
            isOverloaded = true;
        }
        if (!isOverloaded) {
            this.overrides.put(_name, sequenceNum);
        }
        return NLS.bind((String)"{0}{1}Test", (Object[])new String[]{_name, String.valueOf(sequenceNum)});
    }
}

