/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.core.api;

import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.jmunit.core.api.AbstractTestWriter;
import org.eclipse.osgi.util.NLS;

public class TestSuiteWriter
extends AbstractTestWriter {
    private String suiteName;

    public TestSuiteWriter(IType _type, String _name) throws JavaModelException {
        super(_type);
        this.suiteName = _name;
    }

    public void updateSetupSuiteMethod(String[] _testClasses, IProgressMonitor _monitor) throws JavaModelException {
        ICompilationUnit compilationUnit = this.type.getCompilationUnit();
        Document document = new Document(compilationUnit.getBuffer().getContents());
        IMethod method = this.type.getMethod("setupSuite", new String[0]);
        try {
            if (method != null) {
                ISourceRange methodRange = method.getSourceRange();
                StringBuffer methodBuffer = new StringBuffer(document.get(methodRange.getOffset(), methodRange.getLength()));
                StringBuffer adds = new StringBuffer();
                adds.append(this.delimiter);
                String[] stringArray = _testClasses;
                int n = _testClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    String test = stringArray[n2];
                    adds.append(NLS.bind((String)"add(new {0}());", (Object)test));
                    adds.append(this.delimiter);
                    ++n2;
                }
                int start = methodBuffer.indexOf("JMUnit-BEGIN") + "JMUnit-BEGIN".length();
                int end = methodBuffer.indexOf("//", start);
                methodBuffer.replace(start, end, adds.toString());
                document.replace(methodRange.getOffset(), methodRange.getLength(), methodBuffer.toString());
                String formatted = Utils.codeFormat((IJavaProject)compilationUnit.getJavaProject(), (String)document.get(), (int)8, (int)0, (String)this.delimiter);
                IBuffer buf = compilationUnit.getBuffer();
                buf.replace(0, buf.getLength(), formatted);
                compilationUnit.save((IProgressMonitor)new NullProgressMonitor(), true);
            }
        }
        catch (BadLocationException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }

    public void writeCode(String[] _testCases, IProgressMonitor _monitor) throws JavaModelException {
        this.writeConstructor(_monitor);
        this.writeSuiteSetup(_testCases, _monitor);
    }

    private IMethod writeConstructor(IProgressMonitor _monitor) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        String[] comment = new String[]{"TestSuite Class constructor initializes the test suite."};
        this.writeMethodComment(buffer, comment, this.delimiter);
        String declaration = NLS.bind((String)"public {0}()", (Object)this.type.getElementName());
        String[] body = new String[]{NLS.bind((String)"super(\"{0}\");", (Object)this.suiteName), "this.setupSuite();"};
        this.writeMethodDeclaration(buffer, declaration, body, this.delimiter);
        return this.type.createMethod(buffer.toString(), null, false, _monitor);
    }

    private IMethod writeSuiteSetup(String[] _testCases, IProgressMonitor _monitor) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        String[] comment = new String[]{"This method adds all suite test cases to be run."};
        this.writeMethodComment(buffer, comment, this.delimiter);
        String declaration = "private void setupSuite()";
        LinkedList<String> body = new LinkedList<String>();
        body.add("//JMUnit-BEGIN");
        String[] stringArray = _testCases;
        int n = _testCases.length;
        int n2 = 0;
        while (n2 < n) {
            String testCase = stringArray[n2];
            body.add(NLS.bind((String)"add(new {0}());", (Object)testCase));
            ++n2;
        }
        body.add("//JMUnit-END");
        this.writeMethodDeclaration(buffer, declaration, body.toArray(new String[body.size()]), this.delimiter);
        return this.type.createMethod(buffer.toString(), null, false, _monitor);
    }
}

