/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.templates;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.mtj.internal.templates.Messages;
import org.eclipse.mtj.ui.templates.AbstractTemplateWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplashApplicationWizardPage
extends AbstractTemplateWizardPage {
    private Text imageText;
    private Button size1;
    private Button size2;
    private Button size3;
    private Text colorText;
    private Text timeText;

    public void createControl(Composite parent) {
        GridData data = null;
        parent.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(parent, 0);
        group.setText(Messages.SplashTemplateProvider_0);
        data = new GridData(4, 4, true, false);
        group.setLayoutData((Object)data);
        group.setLayout((Layout)new GridLayout(3, false));
        Label imageLabel = new Label((Composite)group, 0);
        imageLabel.setText(Messages.SplashTemplateProvider_1);
        data = new GridData(4);
        imageLabel.setLayoutData((Object)data);
        this.imageText = new Text((Composite)group, 2048);
        this.imageText.setText(Messages.SplashTemplateProvider_2);
        this.imageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SplashApplicationWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        this.imageText.setLayoutData((Object)data);
        Group sizesGroup = new Group((Composite)group, 0);
        sizesGroup.setText(Messages.SplashTemplateProvider_3);
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 3;
        sizesGroup.setLayoutData((Object)data);
        sizesGroup.setLayout((Layout)new GridLayout(3, false));
        this.size1 = new Button((Composite)sizesGroup, 16);
        this.size1.setText("128 x 160");
        data = new GridData(768);
        this.size1.setLayoutData((Object)data);
        this.size1.setSelection(true);
        this.size2 = new Button((Composite)sizesGroup, 16);
        this.size2.setText("176 x 220");
        data = new GridData(768);
        this.size2.setLayoutData((Object)data);
        this.size3 = new Button((Composite)sizesGroup, 16);
        this.size3.setText("240 x 320");
        data = new GridData(768);
        this.size3.setLayoutData((Object)data);
        Label colorLabel = new Label((Composite)group, 0);
        colorLabel.setText(Messages.SplashTemplateProvider_7);
        data = new GridData(4);
        colorLabel.setLayoutData((Object)data);
        this.colorText = new Text((Composite)group, 2048);
        this.colorText.setText("0xFFFFFF");
        this.colorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SplashApplicationWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        this.colorText.setLayoutData((Object)data);
        Label formatLabel = new Label((Composite)group, 0);
        formatLabel.setText(Messages.SplashTemplateProvider_9);
        data = new GridData(4);
        formatLabel.setLayoutData((Object)data);
        Label timeLabel = new Label((Composite)group, 0);
        timeLabel.setText(Messages.SplashTemplateProvider_10);
        data = new GridData(4);
        timeLabel.setLayoutData((Object)data);
        this.timeText = new Text((Composite)group, 2048);
        this.timeText.setText("3000");
        this.timeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SplashApplicationWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        this.timeText.setLayoutData((Object)data);
    }

    public Map<String, String> getDictionary() {
        HashMap<String, String> dictionary = new HashMap<String, String>();
        dictionary.put("$image-name$", this.imageText.getText());
        dictionary.put("$image-size$", this.getImageSize());
        dictionary.put("$splash-time$", this.timeText.getText());
        dictionary.put("$bg-color$", this.colorText.getText());
        return dictionary;
    }

    private String getImageSize() {
        StringBuffer buffer = new StringBuffer();
        if (this.size1.getSelection()) {
            buffer.append("_128x160");
        } else if (this.size2.getSelection()) {
            buffer.append("_176x220");
        } else if (this.size3.getSelection()) {
            buffer.append("_240x320");
        }
        return buffer.toString();
    }

    public boolean isPageComplete() {
        boolean result = true;
        result &= Pattern.matches("(0x)([a-fA-F0-9]){6}", this.colorText.getText());
        result &= Pattern.matches("\\d+", this.timeText.getText());
        return result &= this.imageText.getText().length() > 0;
    }
}

