/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.cinterion;

import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.project.ProjectType;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.mtj.internal.toolkit.cinterion.CinterionCore;
import org.eclipse.mtj.internal.toolkit.uei.UEIDeviceInternal;
import org.eclipse.mtj.internal.toolkit.uei.properties.DeviceSpecificProperties;
import org.eclipse.mtj.internal.toolkit.uei.properties.UEIDeviceDefinition;
import org.osgi.framework.Version;

public class CinterionDevice
extends UEIDeviceInternal {
    public CinterionDevice() {
    }

    public CinterionDevice(String name, String groupName, String description, Properties properties, UEIDeviceDefinition definition, File emulatorExecutable, IPreverifier preverifier) throws IllegalArgumentException {
        super(name, groupName, description, properties, definition, emulatorExecutable, preverifier);
        this.setBundle(CinterionCore.getDefault().getBundle().getSymbolicName());
    }

    protected IDeviceClasspath getBootClasspath(Properties deviceProperties) {
        IDeviceClasspath deviceClasspath = MTJCore.createNewDeviceClasspath();
        String classpathString = deviceProperties.getProperty(DeviceSpecificProperties.BOOTCLASSPATH.toString(), "");
        deviceClasspath.addEntry(this.createLibraries(classpathString));
        return deviceClasspath;
    }

    public String getBundle() {
        return CinterionCore.getDefault().getBundle().getSymbolicName();
    }

    private ILibrary createLibraries(String classpath) {
        ArrayList<IMIDPAPI> apis = new ArrayList<IMIDPAPI>();
        IMIDPAPI midp = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        midp.setIdentifier("IMP-NG");
        midp.setType(MIDPAPIType.PROFILE);
        midp.setName("Information Module Profile");
        midp.setVersion(new Version("1.0"));
        apis.add(midp);
        IMIDPAPI cldc = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        cldc.setIdentifier("CLDC");
        cldc.setType(MIDPAPIType.CONFIGURATION);
        cldc.setName("Connected Limited Device Configuration");
        cldc.setVersion(new Version("1.1"));
        apis.add(cldc);
        IMIDPAPI icmAPI = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        icmAPI.setIdentifier("SIEMENS-ICM");
        icmAPI.setType(MIDPAPIType.OPTIONAL);
        icmAPI.setName("Siemens Icm");
        icmAPI.setVersion(new Version("1.0"));
        apis.add(icmAPI);
        IMIDPLibrary library = (IMIDPLibrary)MTJCore.createNewLibrary((ProjectType)ProjectType.MIDLET_SUITE);
        library.setLibraryFile(new File(classpath));
        library.setApis(apis);
        return library;
    }
}

