/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.mpowerplayer;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.sdk.ISDK;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.ILibraryImporter;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.sdk.BasicSDK;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDeviceImporter;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDeviceProperties;
import org.eclipse.mtj.internal.core.sdk.device.midp.Configuration;
import org.eclipse.mtj.internal.core.sdk.device.midp.Profile;
import org.eclipse.mtj.internal.core.util.ReplaceableParametersProcessor;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.toolkit.mpowerplayer.Messages;
import org.eclipse.mtj.internal.toolkit.mpowerplayer.MpowerplayerDevice;
import org.eclipse.mtj.internal.toolkit.mpowerplayer.MpowerplayerPlugin;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MpowerplayerDeviceImporter
extends JavaEmulatorDeviceImporter {
    private static final String MACOSX_OS_NAME = "Mac OS X";
    private static String osName = System.getProperty("os.name");
    private static final String PLAYER_JAR_NAME = "player.jar";
    private static final String PLAYER_MACOSX_PREVERIFIER = "/osx/preverify";
    private static final String PLAYER_MAIN_CLASS = "com.mpp.player.PowerPlayerApp";
    private static final String PROPS_FILE = "mpowerplayer.properties";

    public List<IDevice> importDevices(File directory, IProgressMonitor monitor) {
        ArrayList<IDevice> deviceList = null;
        try {
            IDevice device;
            File jarFile = new File(directory, PLAYER_JAR_NAME);
            if (jarFile.exists() && this.hasMainClassAttribute(jarFile, PLAYER_MAIN_CLASS) && (device = this.createDevice(jarFile)) != null) {
                deviceList = new ArrayList<IDevice>(1);
                deviceList.add(device);
            }
        }
        catch (Exception e) {
            MTJLogger.log((int)2, (String)Messages.MpowerplayerDeviceImporter_import_error, (Throwable)e);
        }
        return deviceList;
    }

    private void addMplayerDeviceLibraries(File jarFile, IDeviceClasspath deviceClasspath, ILibraryImporter importer) {
        String[] entries;
        String classpathString = this.getDeviceProperties().getProperty(JavaEmulatorDeviceProperties.CLASSPATH.toString(), "");
        HashMap<String, String> replaceableParameters = new HashMap<String, String>();
        replaceableParameters.put("mpproot", jarFile.getParent());
        classpathString = ReplaceableParametersProcessor.processReplaceableValues((String)classpathString, replaceableParameters);
        String[] stringArray = entries = classpathString.split(";");
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entrie = stringArray[n2];
            IMIDPLibrary library = (IMIDPLibrary)importer.createLibraryFor(new File(entrie));
            IMIDPAPI api = library.getAPI(MIDPAPIType.UNKNOWN);
            if (api != null) {
                if (api.getIdentifier().equalsIgnoreCase("cldc-1.1.jar")) {
                    api.setIdentifier(Configuration.CLDC_11.getIdentifier());
                    api.setType(MIDPAPIType.CONFIGURATION);
                    api.setName(Configuration.CLDC_11.getName());
                    api.setVersion(Configuration.CLDC_11.getVersion());
                } else if (api.getIdentifier().equalsIgnoreCase("midp-2.0.jar")) {
                    api.setIdentifier(Profile.MIDP_20.getIdentifier());
                    api.setType(MIDPAPIType.PROFILE);
                    api.setName(Profile.MIDP_20.getName());
                    api.setVersion(Profile.MIDP_20.getVersion());
                } else if (api.getIdentifier().equalsIgnoreCase("m2d.jar")) {
                    api.setIdentifier("JSR226");
                    api.setType(MIDPAPIType.OPTIONAL);
                    api.setName("Scalable 2D Vector Graphics API for J2ME");
                    api.setVersion(new Version("1.0"));
                } else if (api.getIdentifier().equalsIgnoreCase("m3g.jar")) {
                    api.setIdentifier("JSR184");
                    api.setType(MIDPAPIType.OPTIONAL);
                    api.setName("Mobile 3D Graphics API for J2ME");
                    api.setVersion(new Version("1.0"));
                } else if (api.getIdentifier().equalsIgnoreCase("mmapi.jar")) {
                    api.setIdentifier("MMAPI");
                    api.setType(MIDPAPIType.OPTIONAL);
                    api.setName("Mobile Media API");
                    api.setVersion(new Version("1.0"));
                }
            }
            deviceClasspath.addEntry((ILibrary)library);
            ++n2;
        }
    }

    private IDevice createDevice(File jarFile) {
        MpowerplayerDevice device = new MpowerplayerDevice();
        device.setBundle(MpowerplayerPlugin.getDefault().getBundle().getSymbolicName());
        device.setClasspath(this.getDeviceClasspath(jarFile));
        device.setDebugServer(this.isDebugServer());
        device.setDescription("Mpowerplayer Device");
        device.setDeviceProperties(new Properties());
        device.setGroupName("Mpowerplayer");
        device.setName("Mpowerplayer");
        device.setPreverifier(this.getPreverifier(jarFile));
        device.setProtectionDomains(new String[0]);
        device.setLaunchCommandTemplate(this.getLaunchCommand());
        device.setMppRoot(jarFile.getParentFile());
        ISymbolSet dss = MTJCore.getSymbolSetFactory().createSymbolSetFromDevice((IDevice)device);
        dss.setName(device.getName());
        device.setSymbolSet(dss);
        Version v = new Version(1, 0, 0);
        ISDK sdk = BasicSDK.getSDK((String)"Mpowerplayer", (Version)v);
        device.setSDK(sdk);
        ((BasicSDK)sdk).addDevice((IDevice)device);
        return device;
    }

    private File findEmbeddedPreverifyExtecutable(File directory) {
        File[] files = directory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String name = pathname.getName();
                return pathname.isDirectory() || name.equals("preverify");
            }
        });
        File executable = null;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory()) {
                executable = file;
                break;
            }
            executable = this.findEmbeddedPreverifyExtecutable(file);
            ++n2;
        }
        return executable;
    }

    private IDeviceClasspath getDeviceClasspath(File jarFile) {
        IDeviceClasspath deviceClasspath = MTJCore.createNewDeviceClasspath();
        ILibraryImporter importer = MTJCore.getLibraryImporter((String)"org.eclipse.mtj.libraryimporter.uei");
        this.addMplayerDeviceLibraries(jarFile, deviceClasspath, importer);
        return deviceClasspath;
    }

    protected URL getDevicePropertiesURL() {
        return MpowerplayerPlugin.getDefault().getBundle().getEntry(PROPS_FILE);
    }

    protected IPreverifier getPreverifier(File jarFile) {
        File macOsPreverifierPath;
        File preverifyExecutable;
        IPreverifier preverifier = super.getPreverifier(jarFile);
        if (osName.equals(MACOSX_OS_NAME) && (preverifyExecutable = this.findEmbeddedPreverifyExtecutable(macOsPreverifierPath = new File(String.valueOf(jarFile.getParentFile().getPath()) + PLAYER_MACOSX_PREVERIFIER))) != null) {
            try {
                preverifier = MTJCore.createPreverifier((String)"org.eclipse.mtj.preverifier.standard", (Object)preverifyExecutable);
            }
            catch (CoreException e) {
                MTJLogger.log((int)2, (String)Messages.MpowerplayerDeviceImporter_preverifier_import_error, (Throwable)e);
            }
        }
        return preverifier;
    }
}

