/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.nokia;

import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.project.ProjectType;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.mtj.internal.toolkit.nokia.NokiaCore;
import org.eclipse.mtj.internal.toolkit.uei.UEIDeviceInternal;
import org.eclipse.mtj.internal.toolkit.uei.properties.DeviceSpecificProperties;
import org.eclipse.mtj.internal.toolkit.uei.properties.UEIDeviceDefinition;
import org.osgi.framework.Version;

public class NokiaS603rdFP1Device
extends UEIDeviceInternal {
    public NokiaS603rdFP1Device() {
    }

    public NokiaS603rdFP1Device(String name, String groupName, String description, Properties properties, UEIDeviceDefinition definition, File emulatorExecutable, IPreverifier preverifier) throws IllegalArgumentException {
        super(name, groupName, description, properties, definition, emulatorExecutable, preverifier);
        this.setBundle(NokiaCore.getDefault().getBundle().getSymbolicName());
    }

    protected IDeviceClasspath getBootClasspath(Properties deviceProperties) {
        IDeviceClasspath deviceClasspath = MTJCore.createNewDeviceClasspath();
        String classpathString = deviceProperties.getProperty(DeviceSpecificProperties.BOOTCLASSPATH.toString(), "");
        deviceClasspath.addEntry(this.createLibraries(classpathString));
        return deviceClasspath;
    }

    public String getBundle() {
        return NokiaCore.getDefault().getBundle().getSymbolicName();
    }

    private ILibrary createLibraries(String classpath) {
        ArrayList<IMIDPAPI> apis = new ArrayList<IMIDPAPI>();
        IMIDPAPI midp = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        midp.setIdentifier("MIDP");
        midp.setType(MIDPAPIType.PROFILE);
        midp.setName("Mobile Information Device Profile");
        midp.setVersion(new Version("2.0"));
        apis.add(midp);
        IMIDPAPI cldc = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        cldc.setIdentifier("CLDC");
        cldc.setType(MIDPAPIType.CONFIGURATION);
        cldc.setName("Connected Limited Device Configuration");
        cldc.setVersion(new Version("1.1"));
        apis.add(cldc);
        IMIDPAPI jsr75 = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        jsr75.setIdentifier("JSR75");
        jsr75.setType(MIDPAPIType.OPTIONAL);
        jsr75.setName("PDA Optional Packages for the J2ME Platform");
        jsr75.setVersion(new Version("1.0"));
        apis.add(jsr75);
        IMIDPAPI jsr82 = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        jsr82.setIdentifier("JSR82");
        jsr82.setType(MIDPAPIType.OPTIONAL);
        jsr82.setName("Java APIs for Bluetooth");
        jsr82.setVersion(new Version("1.1"));
        apis.add(jsr82);
        IMIDPAPI jsr135 = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        jsr135.setIdentifier("MMAPI");
        jsr135.setType(MIDPAPIType.OPTIONAL);
        jsr135.setName("Mobile Media API");
        jsr135.setVersion(new Version("1.1"));
        apis.add(jsr135);
        IMIDPAPI wma = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        wma.setIdentifier("WMA");
        wma.setType(MIDPAPIType.OPTIONAL);
        wma.setName("Wireless Messaging API");
        wma.setVersion(new Version("2.0"));
        apis.add(wma);
        IMIDPAPI jsr172 = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        jsr172.setIdentifier("JSR172");
        jsr172.setType(MIDPAPIType.OPTIONAL);
        jsr172.setName("Web Services");
        jsr172.setVersion(new Version("1.0"));
        apis.add(jsr172);
        IMIDPAPI jsr177 = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        jsr177.setIdentifier("JSR177");
        jsr177.setType(MIDPAPIType.OPTIONAL);
        jsr177.setName("Security and Trust Services API");
        jsr177.setVersion(new Version("1.0"));
        apis.add(jsr177);
        IMIDPAPI jsr179 = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        jsr179.setIdentifier("JSR179");
        jsr179.setType(MIDPAPIType.OPTIONAL);
        jsr179.setName("Location API");
        jsr179.setVersion(new Version("1.0"));
        apis.add(jsr179);
        IMIDPAPI jsr180 = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        jsr180.setIdentifier("JSR180");
        jsr180.setType(MIDPAPIType.OPTIONAL);
        jsr180.setName("SIP API");
        jsr180.setVersion(new Version("1.0.1"));
        apis.add(jsr180);
        IMIDPAPI jsr184 = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        jsr184.setIdentifier("JSR184");
        jsr184.setType(MIDPAPIType.OPTIONAL);
        jsr184.setName("Mobile 3D Graphics API");
        jsr184.setVersion(new Version("1.1"));
        apis.add(jsr184);
        IMIDPAPI jsr226 = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        jsr226.setIdentifier("JSR226");
        jsr226.setType(MIDPAPIType.OPTIONAL);
        jsr226.setName("Scalable 2D Vector Graphics API");
        jsr226.setVersion(new Version("1.0"));
        apis.add(jsr226);
        IMIDPAPI jsr234 = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        jsr234.setIdentifier("JSR234");
        jsr234.setType(MIDPAPIType.OPTIONAL);
        jsr234.setName("Advanced Multimedia Supplements");
        jsr234.setVersion(new Version("1.0"));
        apis.add(jsr234);
        IMIDPAPI nokiaApi = (IMIDPAPI)MTJCore.createNewAPI((ProjectType)ProjectType.MIDLET_SUITE);
        nokiaApi.setIdentifier("Nokia UI");
        nokiaApi.setType(MIDPAPIType.OPTIONAL);
        nokiaApi.setName("Nokia UI API");
        nokiaApi.setVersion(new Version("1.1"));
        apis.add(nokiaApi);
        IMIDPLibrary library = (IMIDPLibrary)MTJCore.createNewLibrary((ProjectType)ProjectType.MIDLET_SUITE);
        library.setLibraryFile(new File(classpath));
        library.setApis(apis);
        return library;
    }
}

