/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.uei;

import java.io.File;
import java.util.Properties;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.sdk.ISDK;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.sdk.BasicSDK;
import org.eclipse.mtj.internal.core.sdk.device.JavadocDetector;
import org.eclipse.mtj.internal.core.sdk.device.midp.UEILibraryImporter;
import org.eclipse.mtj.internal.toolkit.uei.Messages;
import org.eclipse.mtj.internal.toolkit.uei.UEIDevice;
import org.eclipse.mtj.internal.toolkit.uei.UeiPlugin;
import org.eclipse.mtj.internal.toolkit.uei.properties.DeviceSpecificProperties;
import org.eclipse.mtj.internal.toolkit.uei.properties.UEIDeviceDefinition;
import org.osgi.framework.Version;

public class UEIDeviceInternal
extends UEIDevice {
    public UEIDeviceInternal() {
    }

    public UEIDeviceInternal(String name, String groupName, String description, Properties properties, UEIDeviceDefinition definition, File emulatorExecutable, IPreverifier preverifier) throws IllegalArgumentException {
        if (properties == null) {
            throw new IllegalArgumentException(Messages.UEIDevice_null_properties);
        }
        if (definition == null) {
            throw new IllegalArgumentException(Messages.UEIDevice_null_definition);
        }
        this.setName(name);
        this.setDescription(description);
        this.setGroupName(groupName);
        this.setDeviceProperties(properties);
        this.setClasspath(this.getBootClasspath(properties));
        this.setProtectionDomains(this.getProtectionDomains(properties));
        this.setExecutable(emulatorExecutable);
        this.setPreverifier(preverifier);
        this.setDebugServer(definition.isDebugServer());
        this.setLaunchCommandTemplate(definition.getLaunchTemplate());
        this.setBundle(UeiPlugin.getDefault().getBundle().getSymbolicName());
        ISymbolSet dss = MTJCore.getSymbolSetFactory().createSymbolSetFromDevice((IDevice)this);
        ISymbolSet pss = MTJCore.getSymbolSetFactory().createSymbolSetFromProperties(this.deviceProperties);
        dss.add(pss.getSymbols());
        dss.setName(this.getName());
        this.setSymbolSet(dss);
        Version v = new Version(1, 0, 0);
        ISDK sdk = BasicSDK.getSDK((String)groupName, (Version)v);
        this.setSDK(sdk);
        ((BasicSDK)sdk).addDevice((IDevice)this);
    }

    protected IDeviceClasspath getBootClasspath(Properties deviceProperties) {
        IDeviceClasspath deviceClasspath = MTJCore.createNewDeviceClasspath();
        String classpathString = deviceProperties.getProperty(DeviceSpecificProperties.BOOTCLASSPATH.toString(), "");
        String[] classpathEntries = classpathString.split(",");
        JavadocDetector javadocDetector = new JavadocDetector();
        UEILibraryImporter libraryImporter = (UEILibraryImporter)MTJCore.getLibraryImporter((String)"org.eclipse.mtj.libraryimporter.uei");
        libraryImporter.setJavadocDetector(javadocDetector);
        String[] stringArray = classpathEntries;
        int n = classpathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            File libraryFile = new File(element);
            if (libraryFile.exists()) {
                deviceClasspath.addEntry((ILibrary)libraryImporter.createLibraryFor(libraryFile));
            }
            ++n2;
        }
        return deviceClasspath;
    }

    private String[] getProtectionDomains(Properties deviceProperties) {
        String domainsString = deviceProperties.getProperty(DeviceSpecificProperties.SECURITY_DOMAINS.toString(), "");
        return domainsString.split(",");
    }
}

