/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.uei.properties;

import org.eclipse.mtj.internal.toolkit.uei.properties.UEIImplementationReq;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DeviceSpecificProperties {
    APIS("apis", UEIImplementationReq.OPTIONAL),
    BOOTCLASSPATH("bootclasspath", UEIImplementationReq.REQUIRED),
    DESCRIPTION("description", UEIImplementationReq.OPTIONAL),
    SCREEN_BITDEPTH("screen.bitDepth", UEIImplementationReq.REQUIRED),
    SCREEN_HEIGHT("screen.height", UEIImplementationReq.REQUIRED),
    SCREEN_ISCOLOR("screen.isColor", UEIImplementationReq.REQUIRED),
    SCREEN_ISTOUCH("screen.isTouch", UEIImplementationReq.REQUIRED),
    SCREEN_WIDTH("screen.width", UEIImplementationReq.REQUIRED),
    SECURITY_DOMAINS("security.domains", UEIImplementationReq.OPTIONAL),
    UEI_ARGUMENTS("uei.arguments", UEIImplementationReq.OPTIONAL),
    VERSION_CONFIGURATION("version.configuration", UEIImplementationReq.OPTIONAL),
    VERSION_PROFILE("version.profile", UEIImplementationReq.OPTIONAL);

    private UEIImplementationReq implementationRequirement;
    private String propertyKey;

    private DeviceSpecificProperties(String propertyKey, UEIImplementationReq req) {
        this.propertyKey = propertyKey;
        this.implementationRequirement = req;
    }

    public String getDeviceSpecificProperties(String deviceName) {
        if (deviceName == null) {
            throw new IllegalArgumentException("Device name must not be null.");
        }
        return String.valueOf(deviceName) + "." + this.propertyKey;
    }

    public UEIImplementationReq getImplementationRequirement() {
        return this.implementationRequirement;
    }

    public String toString() {
        return this.propertyKey;
    }
}

