/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.uei.properties;

import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.mtj.internal.toolkit.uei.Messages;
import org.eclipse.mtj.internal.toolkit.uei.properties.UEIDeviceDefinitionProperties;

public class UEIDeviceDefinition {
    private boolean debugServer;
    private String launchTemplate;
    private Pattern matchPattern;
    private String name;
    private boolean predeployRequired;

    public UEIDeviceDefinition(String deviceName, Properties properties) throws IllegalArgumentException, NullPointerException {
        if (deviceName == null) {
            throw new NullPointerException(Messages.UEIDeviceDefinition_deviceName_null);
        }
        if (properties == null) {
            throw new NullPointerException(Messages.UEIDeviceDefinition_properties_null);
        }
        String matchExpression = properties.getProperty(UEIDeviceDefinitionProperties.MATCH_EXPRESSION.createDeviceProperty(deviceName));
        if (matchExpression == null) {
            throw new IllegalArgumentException(Messages.UEIDeviceDefinition_invalid_match_expression);
        }
        Pattern matchPattern = Pattern.compile(matchExpression);
        boolean debugServer = properties.getProperty(UEIDeviceDefinitionProperties.DEBUG_SERVER.createDeviceProperty(deviceName), "").equalsIgnoreCase(Boolean.TRUE.toString());
        boolean predeployRequired = properties.getProperty(UEIDeviceDefinitionProperties.PREDEPLOY_REQUIRED.createDeviceProperty(deviceName), "").equalsIgnoreCase(Boolean.TRUE.toString());
        String launchTemplate = properties.getProperty(UEIDeviceDefinitionProperties.LAUNCH_TEMPLATE.createDeviceProperty(deviceName), "");
        this.setDebugServer(debugServer);
        this.setName(deviceName);
        this.setMatchPattern(matchPattern);
        this.setLaunchTemplate(launchTemplate);
        this.setPredeployRequired(predeployRequired);
    }

    public String getLaunchTemplate() {
        return this.launchTemplate;
    }

    public Pattern getMatchPattern() {
        return this.matchPattern;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDebugServer() {
        return this.debugServer;
    }

    public boolean isPredeployRequired() {
        return this.predeployRequired;
    }

    public void setDebugServer(boolean isDebugServer) {
        this.debugServer = isDebugServer;
    }

    public void setLaunchTemplate(String launchTemplate) {
        this.launchTemplate = launchTemplate;
    }

    public void setMatchPattern(Pattern matchPattern) {
        this.matchPattern = matchPattern;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPredeployRequired(boolean predeployRequired) {
        this.predeployRequired = predeployRequired;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.debugServer ? 1231 : 1237);
        result = 31 * result + (this.launchTemplate == null ? 0 : this.launchTemplate.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.predeployRequired ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UEIDeviceDefinition other = (UEIDeviceDefinition)obj;
        if (this.debugServer != other.debugServer) {
            return false;
        }
        if (this.launchTemplate == null ? other.launchTemplate != null : !this.launchTemplate.equals(other.launchTemplate)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.predeployRequired == other.predeployRequired;
    }
}

