/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.wizard;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.NewTaskWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewBugzillaTaskWizard
extends NewTaskWizard
implements INewWizard {
    private IStructuredSelection selection;

    public NewBugzillaTaskWizard(TaskRepository taskRepository, ITaskMapping taskSelection) {
        super(taskRepository, taskSelection);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected ITaskMapping getInitializationData() {
        ISelection sel;
        IWorkbenchWindow window;
        if (this.getTaskSelection() != null) {
            return this.getTaskSelection();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && (sel = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)sel;
        }
        final AtomicReference<String> product = new AtomicReference<String>();
        final AtomicReference<String> component = new AtomicReference<String>();
        if (this.selection == null || this.selection.isEmpty()) {
            product.set(this.getTaskRepository().getProperty("last.selection.product"));
            component.set(this.getTaskRepository().getProperty("last.selection.component"));
        } else {
            Object element = this.selection.getFirstElement();
            this.extractMapping(element, product, component);
        }
        if (product.get() != null) {
            return new TaskMapping(){

                public String getProduct() {
                    return (String)product.get();
                }

                public String getComponent() {
                    return (String)component.get();
                }
            };
        }
        return null;
    }

    private void extractMapping(Object element, AtomicReference<String> product, AtomicReference<String> component) {
        if (element instanceof ITask) {
            ITask task = (ITask)element;
            product.set(task.getAttribute(BugzillaAttribute.PRODUCT.getKey()));
        } else {
            IAdaptable adaptable;
            ITask task;
            IRepositoryQuery query = null;
            if (element instanceof IRepositoryQuery) {
                query = (IRepositoryQuery)element;
            }
            if (query != null && query.getConnectorKind().equals("bugzilla")) {
                String[] options;
                String queryUrl = query.getUrl();
                queryUrl = queryUrl.substring(queryUrl.indexOf("?") + 1);
                String[] stringArray = options = queryUrl.split("&");
                int n = options.length;
                int n2 = 0;
                while (n2 < n) {
                    String option = stringArray[n2];
                    int index = option.indexOf("=");
                    if (index != -1) {
                        String key = option.substring(0, index);
                        if ("product".equals(key) && product.get() == null) {
                            try {
                                product.set(URLDecoder.decode(option.substring(index + 1), this.getTaskRepository().getCharacterEncoding()));
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {}
                        } else if ("component".equals(key) && component.get() == null) {
                            try {
                                component.set(URLDecoder.decode(option.substring(index + 1), this.getTaskRepository().getCharacterEncoding()));
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {}
                        }
                    }
                    ++n2;
                }
            } else if (element instanceof IAdaptable && (task = (ITask)(adaptable = (IAdaptable)element).getAdapter(ITask.class)) != null) {
                product.set(task.getAttribute(BugzillaAttribute.PRODUCT.getKey()));
            }
        }
    }
}

