/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.internal.core.util;

import java.net.Proxy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.auth.UsernamePasswordCredentials;

public class RepositoryWebLocation
extends AbstractWebLocation {
    private final RepositoryLocation location;

    public RepositoryWebLocation(RepositoryLocation location) {
        super(location.getUrl());
        this.location = location;
    }

    public AuthenticationCredentials getCredentials(AuthenticationType type) {
        UsernamePasswordCredentials credentials;
        if (type != AuthenticationType.CERTIFICATE && (credentials = (UsernamePasswordCredentials)this.location.getCredentials(org.eclipse.mylyn.commons.repositories.auth.AuthenticationType.REPOSITORY, UsernamePasswordCredentials.class)) != null) {
            return new AuthenticationCredentials(credentials.getUserName(), credentials.getPassword());
        }
        return null;
    }

    public Proxy getProxyForHost(String host, String proxyType) {
        return this.location.getService().getProxyForHost(host, proxyType);
    }

    public void requestCredentials(AuthenticationType type, String message, IProgressMonitor monitor) {
        this.location.getService().requestCredentials(org.eclipse.mylyn.commons.repositories.auth.AuthenticationType.REPOSITORY, UsernamePasswordCredentials.class, message, monitor);
    }

    public String getUrl() {
        return this.location.getUrl();
    }
}

