/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.http;

import java.io.IOException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.builds.core.util.ProgressUtil;
import org.eclipse.mylyn.commons.core.IOperationMonitor;
import org.eclipse.mylyn.commons.http.CommonHttpClient;
import org.eclipse.mylyn.commons.http.CommonHttpMethod;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.commons.http.CommonGetMethod;
import org.eclipse.mylyn.internal.commons.http.CommonHeadMethod;
import org.eclipse.mylyn.internal.commons.http.CommonPostMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpOperation<T> {
    private final CommonHttpClient client;

    public HttpOperation(CommonHttpClient client) {
        this.client = client;
    }

    protected CommonHttpMethod createGetMethod(String requestPath) {
        return new CommonGetMethod(requestPath);
    }

    protected CommonHttpMethod createPostMethod(String requestPath) {
        return new CommonPostMethod(requestPath);
    }

    protected CommonHttpMethod createHeadMethod(String requestPath) {
        return new CommonHeadMethod(requestPath);
    }

    protected int execute(HttpMethod method, IOperationMonitor monitor) throws IOException {
        int code;
        monitor = ProgressUtil.convert((IProgressMonitor)monitor);
        if (this.needsAuthentication()) {
            this.client.authenticate(monitor);
        }
        if (this.needsReauthentication(code = this.executeInternal(method, monitor), monitor)) {
            WebUtil.releaseConnection((HttpMethodBase)((HttpMethodBase)method), (IProgressMonitor)monitor);
            this.client.authenticate(monitor);
            return this.executeInternal(method, monitor);
        }
        return code;
    }

    private int executeInternal(HttpMethod method, IOperationMonitor monitor) throws IOException {
        int code;
        try {
            code = WebUtil.execute((HttpClient)this.client.getHttpClient(), (HostConfiguration)this.client.getHostConfiguration(monitor), (HttpMethod)method, (IProgressMonitor)monitor);
        }
        catch (IOException e) {
            WebUtil.releaseConnection((HttpMethodBase)((HttpMethodBase)method), (IProgressMonitor)monitor);
            throw e;
        }
        catch (RuntimeException e) {
            WebUtil.releaseConnection((HttpMethodBase)((HttpMethodBase)method), (IProgressMonitor)monitor);
            throw e;
        }
        return code;
    }

    protected final CommonHttpClient getClient() {
        return this.client;
    }

    protected boolean hasCredentials(AuthenticationCredentials credentials) {
        return credentials != null;
    }

    protected boolean needsAuthentication() {
        return false;
    }

    private boolean needsReauthentication(int code, IOperationMonitor monitor) throws IOException {
        return this.client.needsReauthentication(code, (IProgressMonitor)monitor);
    }
}

