/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.ui.spi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.builds.core.IBuildModel;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.internal.core.BuildModel;
import org.eclipse.mylyn.builds.internal.core.BuildPlan;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.builds.ui.spi.BuildServerWizardPage;
import org.eclipse.mylyn.commons.repositories.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.auth.ICredentialsStore;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiPlugin;
import org.eclipse.mylyn.internal.builds.ui.view.BuildsView;
import org.eclipse.mylyn.internal.commons.repositories.InMemoryCredentialsStore;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildServerWizard
extends Wizard
implements INewWizard {
    private IBuildServer model;
    private IBuildServer original;

    public BuildServerWizard(IBuildServer server) {
        this.original = server;
        this.setNeedsProgressMonitor(true);
        if (this.isNew()) {
            this.setWindowTitle("New Build Server");
            this.setDefaultPageImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_WIZBAN_NEW_WIZ"));
        } else {
            this.setWindowTitle("Build Server Properties");
            this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY_SETTINGS);
        }
    }

    public void setBuildServer(IBuildServer server) {
        this.original = server;
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY_SETTINGS);
    }

    public void addPages() {
        BuildServerWizardPage page = new BuildServerWizardPage("newBuildServer");
        page.init(this.getModel(), this.getSelectedPlans());
        this.initPage(page);
        this.addPage((IWizardPage)page);
    }

    protected void initPage(BuildServerWizardPage page) {
    }

    private List<IBuildPlan> getSelectedPlans() {
        return BuildsUiInternal.getModel().getPlans(this.original);
    }

    public IBuildServer getModel() {
        if (this.model == null) {
            this.model = ((BuildServer)this.original).createWorkingCopy();
            RepositoryLocation workingCopy = new RepositoryLocation(this.original.getLocation());
            if (workingCopy.getProperty("id") == null) {
                workingCopy.setProperty("id", UUID.randomUUID().toString());
            }
            workingCopy.setCredentialsStore((ICredentialsStore)new InMemoryCredentialsStore(workingCopy.getCredentialsStore()));
            ((BuildServer)this.model).setLocation(workingCopy);
        }
        return this.model;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        ((BuildServer)this.getModel()).applyToOriginal();
        this.getModel().getLocation().setIdPreservingCredentialsStore(this.getModel().getLocation().getUrl());
        this.original.getLocation().apply(this.getModel().getLocation());
        if (this.isNew()) {
            BuildsUiInternal.getModel().getServers().add(this.original);
        }
        this.updateSubscription((IBuildModel)BuildsUiInternal.getModel());
        BuildsView.openInActivePerspective();
        BuildsUiPlugin.getDefault().refreshBuilds();
        return true;
    }

    private void updateSubscription(IBuildModel model) {
        List oldPlans = ((BuildModel)model).getPlans(this.original);
        List<IBuildPlan> selectedPlans = ((BuildServerWizardPage)this.getPages()[0]).getSelectedPlans();
        Set<String> oldPlanIds = BuildsUiInternal.toSetOfIds(oldPlans);
        HashSet<String> toRemovePlanIds = new HashSet<String>(oldPlanIds);
        Set<String> toAddPlanIds = BuildsUiInternal.toSetOfIds(selectedPlans);
        toRemovePlanIds.removeAll(toAddPlanIds);
        toAddPlanIds.removeAll(oldPlanIds);
        if (toAddPlanIds.size() > 0) {
            ArrayList<IBuildPlan> addPlans = new ArrayList<IBuildPlan>(toAddPlanIds.size());
            for (IBuildPlan plan : selectedPlans) {
                if (!toAddPlanIds.contains(plan.getId())) continue;
                ((BuildPlan)plan).setServer(this.original);
                addPlans.add(plan);
            }
            model.getPlans().addAll(addPlans);
        }
        if (toRemovePlanIds.size() > 0) {
            ArrayList<IBuildPlan> removePlans = new ArrayList<IBuildPlan>(toRemovePlanIds.size());
            for (IBuildPlan plan : oldPlans) {
                if (!toRemovePlanIds.contains(plan.getId())) continue;
                removePlans.add(plan);
            }
            model.getPlans().removeAll(removePlans);
        }
    }

    private boolean isNew() {
        return ((BuildServer)this.original).eContainer() != BuildsUiInternal.getModel();
    }
}

