/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.ui.BuildsUi;
import org.eclipse.mylyn.commons.ui.notifications.AbstractNotification;
import org.eclipse.mylyn.internal.builds.ui.BuildImages;
import org.eclipse.mylyn.internal.builds.ui.view.BuildLabelProvider;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class BuildNotification
extends AbstractNotification {
    private static final String ID_EVENT_PLAN_STATUS_CHANGED = "org.eclipse.mylyn.builds.ui.events.PlanStatusChanged";
    private static final String ID_EVENT_BUILD_COMPLETED = "org.eclipse.mylyn.builds.ui.events.BuildCompleted";
    private static final String ID_EVENT_BUILD_STARTED = "org.eclipse.mylyn.builds.ui.events.BuildStarted";
    private final IBuildElement element;
    private String description;
    private String label;

    public BuildNotification(String eventId, IBuildElement element) {
        super(eventId);
        this.element = element;
    }

    public int compareTo(AbstractNotification o) {
        return -1;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Image getNotificationImage() {
        if (this.element instanceof IBuildPlan) {
            return CommonImages.getImage((ImageDescriptor)BuildLabelProvider.getImageDescriptor(((IBuildPlan)this.element).getStatus()));
        }
        return null;
    }

    public Image getNotificationKindImage() {
        return CommonImages.getImage((ImageDescriptor)BuildImages.VIEW_BUILDS);
    }

    public void open() {
        BuildsUi.open(this.element);
    }

    public static BuildNotification createNotification(Notification msg) {
        if (msg.getOldValue() == msg.getNewValue()) {
            return null;
        }
        BuildNotification notification = null;
        if (msg.getNotifier() instanceof IBuildPlan) {
            IBuildPlan plan = (IBuildPlan)msg.getNotifier();
            int featureId = msg.getFeatureID(IBuildPlan.class);
            if (featureId == 14) {
                notification = new BuildNotification(ID_EVENT_PLAN_STATUS_CHANGED, (IBuildElement)msg.getNotifier());
                notification.setLabel(NLS.bind((String)"Plan {0}: {1}", (Object)plan.getLabel(), (Object)plan.getStatus().toString()));
                notification.setDescription(plan.getSummary());
            }
        }
        return notification;
    }
}

