/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            throw new ExecutionException("No active workbench window");
        }
        List<IBuildElement> elements = BuildsUiInternal.getElements(event);
        OpenHandler.openBuildElements(page, elements);
        return null;
    }

    public static List<IEditorPart> openBuildElements(IWorkbenchPage page, List<?> elements) {
        if (elements.size() > 0) {
            ArrayList<IEditorPart> parts = new ArrayList<IEditorPart>(elements.size());
            Object item = elements.get(0);
            BuildEditorInput input = null;
            if (item instanceof IBuild) {
                input = new BuildEditorInput((IBuild)item);
            }
            if (input != null) {
                try {
                    IEditorPart part = page.openEditor((IEditorInput)input, "org.eclipse.mylyn.builds.ui.editors.Build");
                    parts.add(part);
                }
                catch (PartInitException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", "Unexpected error while opening build", (Throwable)e));
                }
            }
            return parts;
        }
        return Collections.emptyList();
    }
}

