/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IChange;
import org.eclipse.mylyn.builds.core.IChangeArtifact;
import org.eclipse.mylyn.builds.core.IChangeSet;
import org.eclipse.mylyn.builds.internal.core.Change;
import org.eclipse.mylyn.builds.internal.core.ChangeArtifact;
import org.eclipse.mylyn.internal.builds.ui.editor.AbstractBuildEditorPart;
import org.eclipse.mylyn.internal.builds.ui.editor.ChangesLabelProvider;
import org.eclipse.mylyn.internal.builds.ui.editor.TaskReference;
import org.eclipse.mylyn.internal.team.ui.actions.TaskFinder;
import org.eclipse.mylyn.versions.core.ScmArtifact;
import org.eclipse.mylyn.versions.core.ScmCore;
import org.eclipse.mylyn.versions.core.spi.ScmConnector;
import org.eclipse.mylyn.versions.ui.ScmUi;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.statushandlers.StatusManager;

public class ChangesPart
extends AbstractBuildEditorPart {
    private TreeViewer viewer;
    private MenuManager menuManager;
    private static final String ID_POPUP_MENU = "org.eclipse.mylyn.builds.ui.editor.menu.Changes";

    public ChangesPart() {
        super(320);
        this.setPartName("Changes");
        this.span = 2;
    }

    protected Control createContent(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        IChangeSet changeSet = this.getInput(IBuild.class).getChangeSet();
        this.viewer = new TreeViewer(toolkit.createTree(composite, 256));
        GridDataFactory.fillDefaults().hint(500, 100).grab(true, false).applyTo(this.viewer.getControl());
        this.viewer.setContentProvider((IContentProvider)new ChangesContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ChangesLabelProvider(), null, null));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChangesPart.this.getPage().getSite().getSelectionProvider().setSelection(event.getSelection());
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selection instanceof Change) {
                    ChangesPart.this.open((IChange)((Change)selection));
                }
                if (selection instanceof ChangeArtifact) {
                    try {
                        ChangesPart.this.open((IChangeArtifact)((ChangeArtifact)selection));
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.getPage().getEditorSite().registerContextMenu(ID_POPUP_MENU, this.menuManager, (ISelectionProvider)this.viewer, true);
        Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        if (changeSet == null || changeSet.getChanges().isEmpty()) {
            this.viewer.setInput((Object)"No changes.");
        } else {
            this.viewer.setInput((Object)changeSet);
        }
        toolkit.paintBordersFor(composite);
        return composite;
    }

    private void open(IChangeArtifact changeArtifact) throws CoreException {
        String revision;
        final IResource resource = ScmCore.findResource((String)changeArtifact.getFile());
        if (resource == null) {
            this.getMessageManager().addMessage((Object)ChangesPart.class.getName(), "The selected file is not available in the workspace", null, 2);
            return;
        }
        final ScmConnector connector = ScmCore.getConnector((IResource)resource);
        if (connector == null) {
            this.getMessageManager().addMessage((Object)ChangesPart.class.getName(), "No extension available to open the selected file", null, 2);
            return;
        }
        final String prevRevision = changeArtifact.getPrevRevision();
        String string = revision = changeArtifact.getRevision() != null ? changeArtifact.getRevision() : ((IChange)((ChangeArtifact)changeArtifact).eContainer()).getRevision();
        if (revision == null) {
            this.getMessageManager().addMessage((Object)ChangesPart.class.getName(), "Could not determine change revisions for the selected file", null, 2);
        }
        try {
            final AtomicReference left = new AtomicReference();
            final AtomicReference right = new AtomicReference();
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    block6: {
                        try {
                            ScmArtifact rightArtifact = connector.getArtifact(resource, revision);
                            right.set(rightArtifact.getFileRevision(monitor));
                            if (prevRevision != null) {
                                ScmArtifact leftArtifact = connector.getArtifact(resource, prevRevision);
                                left.set(leftArtifact.getFileRevision(monitor));
                            }
                            if (left.get() != null) break block6;
                            try {
                                IFileRevision[] contributors = rightArtifact.getContributors(monitor);
                                if (contributors != null && contributors.length > 0) {
                                    left.set(contributors[0]);
                                }
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {}
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }
            });
            if (right.get() != null) {
                this.getMessageManager().removeMessage((Object)ChangesPart.class.getName());
                ScmUi.openCompareEditor((IWorkbenchPage)this.getPage().getSite().getPage(), (IFileRevision)((IFileRevision)left.get()), (IFileRevision)((IFileRevision)right.get()));
            } else {
                this.getMessageManager().addMessage((Object)ChangesPart.class.getName(), "Could not determine change revisions for the selected file", null, 2);
            }
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", "Unexpected error", (Throwable)e), 3);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void open(IChange selection) {
        TaskReference reference = new TaskReference();
        reference.setText(selection.getMessage());
        TaskFinder finder = new TaskFinder((Object)reference);
        finder.open();
    }

    static class ChangesContentProvider
    implements ITreeContentProvider {
        private static final Object[] NO_ELEMENTS = new Object[0];
        private IChangeSet input;

        ChangesContentProvider() {
        }

        public void dispose() {
            this.input = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.input = newInput instanceof IChangeSet ? (IChangeSet)newInput : null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == this.input) {
                return this.input.getChanges().toArray();
            }
            if (inputElement instanceof String) {
                return new Object[]{inputElement};
            }
            return NO_ELEMENTS;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IChange) {
                return ((IChange)parentElement).getArtifacts().toArray();
            }
            return NO_ELEMENTS;
        }

        public Object getParent(Object element) {
            if (element instanceof EObject) {
                return ((EObject)element).eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IChangeSet) {
                return !((IChangeSet)element).getChanges().isEmpty();
            }
            if (element instanceof IChange) {
                return !((IChange)element).getArtifacts().isEmpty();
            }
            return false;
        }
    }
}

