/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.pr;

import java.text.DateFormat;
import java.text.MessageFormat;
import org.eclipse.egit.github.core.RepositoryCommit;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.mylyn.internal.github.ui.pr.Messages;
import org.eclipse.ui.model.WorkbenchAdapter;

public class PullRequestCommitAdapter
extends WorkbenchAdapter {
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(2, 3);
    private final RepositoryCommit commit;

    public PullRequestCommitAdapter(RepositoryCommit commit) {
        this.commit = commit;
    }

    public RepositoryCommit getCommit() {
        return this.commit;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return UIIcons.CHANGESET;
    }

    public String getLabel(Object object) {
        return this.commit.getSha().substring(0, 8);
    }

    public StyledString getStyledText(Object object) {
        StyledString styled = new StyledString(this.getLabel(object));
        String desc = this.commit.getCommit().getMessage();
        if (desc != null) {
            int delim = desc.indexOf(10);
            if (delim == -1) {
                delim = 80;
            }
            if (delim < desc.length()) {
                desc = desc.substring(0, delim);
            }
            styled.append(": ").append(desc);
        }
        styled.append(' ');
        String name = this.commit.getCommit().getAuthor().getName();
        String authorWithDate = MessageFormat.format(Messages.PullRequestCommitAdapter_AuthorWithDate, name, DATE_FORMAT.format(this.commit.getCommit().getAuthor().getDate()));
        styled.append(authorWithDate, StyledString.QUALIFIER_STYLER);
        return styled;
    }
}

