/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.hudson.core.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HudsonUrl {
    private static final String ENCODING = "UTF-8";
    String base;
    int depth = 1;
    List<String> exclude;
    String include;
    String key;
    List<String> values;
    String tree;

    public static HudsonUrl create(String base) {
        HudsonUrl url = new HudsonUrl();
        url.base = base;
        return url;
    }

    private HudsonUrl() {
    }

    public HudsonUrl depth(int depth) {
        this.depth = depth;
        return this;
    }

    public HudsonUrl exclude(String exclude) {
        if (this.exclude == null) {
            this.exclude = new ArrayList<String>();
        }
        this.exclude.add(exclude);
        return this;
    }

    public HudsonUrl include(String include) {
        this.include = include;
        return this;
    }

    public HudsonUrl match(String key, List<String> values) {
        this.key = key;
        this.values = values;
        return this;
    }

    public HudsonUrl tree(String tree) {
        this.tree = tree;
        return this;
    }

    public String toUrl() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(this.base);
        sb.append("/api/xml?wrapper=hudson&depth=");
        sb.append(this.depth);
        if (this.include != null) {
            sb.append("&xpath=");
            sb.append(this.include);
            if (this.key != null && this.values != null) {
                sb.append(this.getFilter());
            }
        }
        if (this.exclude != null) {
            for (String value : this.exclude) {
                sb.append("&exclude=");
                sb.append(value);
            }
        }
        if (this.tree != null) {
            sb.append("&tree=");
            sb.append(URLEncoder.encode(this.tree, ENCODING));
        }
        return sb.toString();
    }

    protected String getFilter() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean appendSeparator = false;
        for (String value : this.values) {
            if (appendSeparator) {
                sb.append(" or ");
            } else {
                appendSeparator = true;
            }
            sb.append(this.key);
            sb.append("=");
            sb.append("'");
            sb.append(value);
            sb.append("'");
        }
        sb.append("]");
        return URLEncoder.encode(sb.toString(), ENCODING);
    }
}

