/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.hudson.ui;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.discovery.IDiscoveryLocator;
import org.eclipse.ecf.discovery.IServiceEvent;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.ui.BuildsUi;
import org.eclipse.mylyn.builds.ui.BuildsUiStartup;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.hudson.ui.Messages;
import org.eclipse.osgi.util.NLS;

public class HudsonDiscovery
extends BuildsUiStartup {
    private static final String ECF_DISCOVERY_JMDNS = "ecf.discovery.jmdns";
    private static final String ECF_SINGLETON_DISCOVERY = "ecf.singleton.discovery";
    private static final String HUDSON_MDNS_ID = "_hudson._tcp.local._iana";
    private static final String HUDSON_URL_PROPERTY_ID = "url";
    private static HudsonDiscovery instance;
    private IContainer container;

    public static HudsonDiscovery getInstance() {
        return instance;
    }

    public HudsonDiscovery() {
        instance = this;
    }

    protected IContainer getContainer() throws ContainerCreateException {
        return ContainerFactory.getDefault().createContainer(ECF_DISCOVERY_JMDNS);
    }

    private boolean isNew(URI uri) {
        List servers = BuildsUi.getModel().getServers();
        for (IBuildServer server : servers) {
            try {
                if (!new URI(String.valueOf(server.getUrl()) + "/").normalize().equals(uri)) continue;
                return false;
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return true;
    }

    public void lazyStartup() {
        try {
            this.container = this.getContainer();
            IDiscoveryLocator adapter = (IDiscoveryLocator)this.container.getAdapter(IDiscoveryLocator.class);
            adapter.addServiceListener(new IServiceListener(){

                public void serviceDiscovered(IServiceEvent anEvent) {
                    IServiceInfo serviceInfo = anEvent.getServiceInfo();
                    IServiceID serviceId = serviceInfo.getServiceID();
                    IServiceTypeID serviceTypeId = serviceId.getServiceTypeID();
                    if (serviceTypeId.getName().equals(HudsonDiscovery.HUDSON_MDNS_ID)) {
                        IServiceProperties properties = serviceInfo.getServiceProperties();
                        try {
                            if (properties.getProperty(HudsonDiscovery.HUDSON_URL_PROPERTY_ID) == null) {
                                HudsonDiscovery.this.notifyMessage(Messages.HudsonDiscovery_MessageTitle, NLS.bind((String)Messages.HudsonDiscovery_MissingURL, (Object[])new Object[]{serviceInfo.getLocation().getHost()}));
                            } else {
                                String hudsonUrl = properties.getProperty(HudsonDiscovery.HUDSON_URL_PROPERTY_ID).toString();
                                URI uri = new URI(String.valueOf(hudsonUrl) + "/").normalize();
                                if (HudsonDiscovery.this.isNew(uri)) {
                                    HudsonDiscovery.this.notifyMessage(Messages.HudsonDiscovery_MessageTitle, NLS.bind((String)Messages.HudsonDiscovery_MessageText, (Object[])new Object[]{uri, Messages.HudsonDiscovery_ServerName, uri.toString(), UUID.randomUUID().toString()}));
                                }
                            }
                        }
                        catch (URISyntaxException e) {
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.hudson.ui", NLS.bind((String)Messages.HudsonDiscovery_IncorrectURI, (Object[])new Object[]{properties.getProperty(HudsonDiscovery.HUDSON_URL_PROPERTY_ID).toString()}), (Throwable)e));
                        }
                    }
                }

                public void serviceUndiscovered(IServiceEvent anEvent) {
                }
            });
            this.container.connect(null, null);
        }
        catch (ContainerCreateException e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.hudson.ui", Messages.HudsonDiscovery_CouldNotStartService, (Throwable)e));
        }
        catch (ContainerConnectException e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.hudson.ui", Messages.HudsonDiscovery_CouldNotStartService, (Throwable)e));
        }
    }

    public void stop() {
        if (this.container != null) {
            this.container.disconnect();
            this.container = null;
        }
    }

    private void notifyMessage(String title, String description) {
        BuildsUi.serverDiscovered((String)title, (String)description);
    }
}

