/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mylyn.internal.resources.ui.IResourceExclusionStrategy;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiPreferenceInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcePatternExclusionStrategy
implements IResourceExclusionStrategy {
    private static final String TRAILING_PATH_WILDCARD = "/**";
    private static final String LEADING_PATH_WILDCARD = "**/";
    private Set<String> excludedPatterns = new HashSet<String>();

    @Override
    public void init() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void update() {
        HashSet<String> excludedPatterns = new HashSet<String>();
        Set<String> excludedResourcePatterns = ResourcesUiPreferenceInitializer.getExcludedResourcePatterns();
        excludedResourcePatterns.addAll(ResourcesUiPreferenceInitializer.getForcedExcludedResourcePatterns());
        for (String pattern : excludedResourcePatterns) {
            if (pattern == null || pattern.length() <= 0) continue;
            excludedPatterns.add(pattern);
        }
        this.excludedPatterns = excludedPatterns;
    }

    @Override
    public boolean isExcluded(IResource resource) {
        return ResourcePatternExclusionStrategy.isExcluded(resource.getProjectRelativePath(), resource, this.excludedPatterns);
    }

    public static boolean isExcluded(IPath path, IResource resource, Set<String> excludedPatterns) {
        if (resource != null && resource.isDerived()) {
            return true;
        }
        String pathString = path.toPortableString();
        for (String pattern : excludedPatterns) {
            if (resource != null && pattern.startsWith("file:/") && ResourcePatternExclusionStrategy.isUriExcluded(resource.getLocationURI().toString(), pattern)) {
                return true;
            }
            if (!SelectorUtils.matchPath((String)pattern, (String)pathString, (boolean)false) && !SelectorUtils.match((String)pattern, (String)pathString, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUriExcluded(String uri, String pattern) {
        return uri != null && uri.startsWith(pattern);
    }

    public static Collection<String> convertToAntPattern(String basicPattern) {
        HashSet<String> patterns = new HashSet<String>();
        patterns.add(basicPattern);
        if (!basicPattern.contains(LEADING_PATH_WILDCARD) && !basicPattern.contains(TRAILING_PATH_WILDCARD)) {
            patterns.add(LEADING_PATH_WILDCARD + basicPattern + TRAILING_PATH_WILDCARD);
            patterns.add(LEADING_PATH_WILDCARD + basicPattern);
            patterns.add(String.valueOf(basicPattern) + TRAILING_PATH_WILDCARD);
        }
        return patterns;
    }
}

