/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.data;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.data.TaskAttributeDiff;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskAttributeDiff;
import org.eclipse.mylyn.tasks.core.data.ITaskDataDiff;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDataDiff
implements ITaskDataDiff {
    private final String[] ATTRIBUTES_IDS = new String[]{"task.common.summary", "task.common.description", "task.common.product", "task.common.priority", "task.common.user.assigned", "task.common.status"};
    private final TaskData newTaskData;
    private final TaskData oldTaskData;
    private final Set<ITaskComment> newComments = new LinkedHashSet<ITaskComment>();
    private final Set<ITaskAttributeDiff> changedAttributes = new LinkedHashSet<ITaskAttributeDiff>();
    private final RepositoryModel repositoryModel;
    public boolean hasChanged;
    private final TaskRepository repository;

    public TaskDataDiff(RepositoryModel repositoryModel, TaskData newTaskData, TaskData oldTaskData) {
        Assert.isNotNull((Object)repositoryModel);
        Assert.isNotNull((Object)newTaskData);
        this.repositoryModel = repositoryModel;
        this.repository = newTaskData.getAttributeMapper().getTaskRepository();
        this.newTaskData = newTaskData;
        this.oldTaskData = oldTaskData;
        this.hasChanged = true;
        this.parse();
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public void setHasChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
    }

    @Override
    public TaskRepository getRepository() {
        return this.repository;
    }

    public TaskData getOldTaskData() {
        return this.oldTaskData;
    }

    public TaskData getNewTaskData() {
        return this.newTaskData;
    }

    @Override
    public Collection<ITaskComment> getNewComments() {
        return this.newComments;
    }

    @Override
    public Collection<ITaskAttributeDiff> getChangedAttributes() {
        return this.changedAttributes;
    }

    private void parse() {
        String[] stringArray = this.ATTRIBUTES_IDS;
        int n = this.ATTRIBUTES_IDS.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeId = stringArray[n2];
            TaskAttribute newAttribute = this.newTaskData.getRoot().getMappedAttribute(attributeId);
            TaskAttribute oldAttribute = null;
            if (this.oldTaskData != null) {
                oldAttribute = this.oldTaskData.getRoot().getMappedAttribute(attributeId);
            }
            if (oldAttribute != null || newAttribute != null) {
                this.addChangedAttribute(oldAttribute, newAttribute, true);
            }
            ++n2;
        }
        for (TaskAttribute newAttribute : this.newTaskData.getRoot().getAttributes().values()) {
            TaskAttribute oldAttribute = null;
            if (this.oldTaskData != null) {
                oldAttribute = this.oldTaskData.getRoot().getMappedAttribute(newAttribute.getPath());
            }
            this.addChangedAttribute(oldAttribute, newAttribute, false);
        }
        if (this.oldTaskData != null) {
            for (TaskAttribute oldAttribute : this.oldTaskData.getRoot().getAttributes().values()) {
                TaskAttribute newAttribute = this.newTaskData.getRoot().getMappedAttribute(oldAttribute.getPath());
                if (newAttribute != null) continue;
                this.addChangedAttribute(oldAttribute, newAttribute, false);
            }
        }
    }

    private void addChangedAttribute(TaskAttribute oldAttribute, TaskAttribute newAttribute, boolean ignoreKind) {
        TaskAttributeDiff diff;
        TaskAttribute attribute = newAttribute != null ? newAttribute : oldAttribute;
        String type = attribute.getMetaData().getType();
        if ("comment".equals(type)) {
            this.addChangedComment(oldAttribute, newAttribute);
        } else if (!"operation".equals(type) && (ignoreKind || attribute.getMetaData().getKind() != null) && (diff = new TaskAttributeDiff(oldAttribute, newAttribute)).hasChanges()) {
            this.changedAttributes.add(diff);
        }
    }

    private void addChangedComment(TaskAttribute oldAttribute, TaskAttribute newAttribute) {
        ITaskComment comment;
        if (oldAttribute == null && (comment = this.repositoryModel.createTaskComment(newAttribute)) != null) {
            this.newComments.add(comment);
        }
    }
}

