/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.versions.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.versions.ui.spi.ScmConnectorUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.core.history.LocalFileRevision;
import org.eclipse.team.internal.ui.history.CompareFileRevisionEditorInput;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IWorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScmUi {
    private static HashMap<String, ScmConnectorUi> connectorById = new HashMap();
    private static final String ID_PLUGIN = "org.eclipse.mylyn.versions.ui";

    protected static ITypedElement getElementFor(IResource resource) {
        return SaveableCompareEditorInput.createFileElement((IFile)((IFile)resource));
    }

    private static IResource getResource(IFileRevision revision) {
        if (revision instanceof LocalFileRevision) {
            LocalFileRevision local = (LocalFileRevision)revision;
            return local.getFile();
        }
        return null;
    }

    public static void openCompareEditor(IWorkbenchPage page, IFileRevision file1, IFileRevision file2) {
        Assert.isNotNull((Object)file2);
        IResource resource = ScmUi.getResource(file2);
        if (resource != null) {
            IFileRevision temp = file1;
            file1 = file2;
            file2 = temp;
        }
        Object left = file1 != null ? ((resource = ScmUi.getResource(file1)) != null ? ScmUi.getElementFor(resource) : new FileRevisionTypedElement(file1, null)) : new EmptyTypedElement(file2.getName());
        FileRevisionTypedElement right = new FileRevisionTypedElement(file2, null);
        CompareFileRevisionEditorInput input = new CompareFileRevisionEditorInput((ITypedElement)left, (ITypedElement)right, page);
        CompareUI.openCompareEditor((CompareEditorInput)input, (boolean)OpenStrategy.activateOnOpen());
    }

    public static List<ScmConnectorUi> getAllRegisteredUiConnectors() {
        String[] teamProviderIds;
        ArrayList<ScmConnectorUi> scmUiConnectors = new ArrayList<ScmConnectorUi>();
        String[] stringArray = teamProviderIds = RepositoryProvider.getAllProviderTypeIds();
        int n = teamProviderIds.length;
        int n2 = 0;
        while (n2 < n) {
            String providerId = stringArray[n2];
            ScmConnectorUi connector = ScmUi.getScmUiConnectorById(providerId);
            if (connector != null) {
                scmUiConnectors.add(connector);
            }
            ++n2;
        }
        return scmUiConnectors;
    }

    public static ScmConnectorUi getUiConnector(IResource resource) {
        if (!RepositoryProvider.isShared((IProject)resource.getProject())) {
            return null;
        }
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject());
        return ScmUi.getScmUiConnectorById(provider.getID());
    }

    private static synchronized ScmConnectorUi getScmUiConnectorById(String id) {
        ScmConnectorUi connector = connectorById.get(id);
        if (connector == null) {
            connector = ScmUi.loadConnector(id);
            connectorById.put(id, connector);
        }
        return connector;
    }

    private static ScmConnectorUi loadConnector(String id) {
        IExtension[] extensions;
        Assert.isNotNull((Object)id);
        MultiStatus result = new MultiStatus(ID_PLUGIN, 0, "Scm ui connectors failed to load.", null);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint connectorsExtensionPoint = registry.getExtensionPoint("org.eclipse.mylyn.versions.ui.connectors");
        IExtension[] iExtensionArray = extensions = connectorsExtensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (id.equals(element.getAttribute("id"))) {
                    try {
                        Object object = element.createExecutableExtension("ui");
                        if (object instanceof ScmConnectorUi) {
                            return (ScmConnectorUi)object;
                        }
                        result.add((IStatus)new Status(4, ID_PLUGIN, NLS.bind((String)"Connector ui ''{0}'' does not extend expected class for extension contributed by {1}", (Object)object.getClass().getCanonicalName(), (Object)element.getContributor().getName())));
                    }
                    catch (Throwable e) {
                        result.add((IStatus)new Status(4, ID_PLUGIN, NLS.bind((String)"Connector core failed to load for extension contributed by {0}", (Object)element.getContributor().getName()), e));
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (!result.isOK()) {
            StatusHandler.log((IStatus)result);
        }
        return null;
    }

    private static class EmptyTypedElement
    implements ITypedElement {
        private final String name;

        public EmptyTypedElement(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return "???";
        }
    }
}

