/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.builder;

import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.XslfoDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.util.DefaultXmlStreamWriter;
import org.eclipse.mylyn.wikitext.core.util.FormattingXMLStreamWriter;
import org.eclipse.mylyn.wikitext.core.util.XmlStreamWriter;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;

public class XslfoDocumentBuilderTest
extends TestCase {
    private StringWriter out;
    private XslfoDocumentBuilder documentBuilder;
    private MarkupParser parser;

    protected void setUp() throws Exception {
        this.out = new StringWriter();
        this.documentBuilder = new XslfoDocumentBuilder((XmlStreamWriter)new FormattingXMLStreamWriter((XmlStreamWriter)new DefaultXmlStreamWriter((Writer)this.out)));
        this.parser = new MarkupParser();
        this.parser.setBuilder((DocumentBuilder)this.documentBuilder);
    }

    public void testXslFoNoMissingBlock_bug304013() {
        this.documentBuilder.getConfiguration().setPageNumbering(true);
        this.documentBuilder.getConfiguration().setTitle("Title");
        this.parser.setMarkupLanguage((MarkupLanguage)new MediaWikiLanguage());
        this.parser.parse("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n{{NonExistantTemplate}}\n\n= H1 =\n\n== H2 ==\n\nsome text");
        XslfoDocumentBuilderTest.assertFalse((boolean)Pattern.compile("<static-content[^>]*></static-content>").matcher(this.out.toString()).find());
    }
}

