/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.tests;

import java.lang.reflect.Modifier;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.mylyn.internal.wikitext.core.WikiTextPlugin;
import org.eclipse.mylyn.wikitext.tests.ClassFilter;
import org.eclipse.mylyn.wikitext.tests.ClassTraversal;
import org.eclipse.mylyn.wikitext.tests.NoDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoDiscovery
public class DiscoveryTestSuite
extends TestSuite
implements ClassFilter {
    public DiscoveryTestSuite(ClassFilter filter) {
        this.discoverTests(filter);
    }

    protected void discoverTests(final ClassFilter filter) {
        new ClassTraversal().visitClasses(new ClassTraversal.Visitor(){

            @Override
            public void visit(Class<?> clazz) {
                if (!DiscoveryTestSuite.this.filter(clazz) && !filter.filter(clazz)) {
                    DiscoveryTestSuite.this.addTest((Test)new TestSuite(clazz));
                }
            }
        });
    }

    public static boolean inEclipseRuntime() {
        return WikiTextPlugin.getDefault() != null;
    }

    @Override
    public boolean filter(Class<?> clazz) {
        if (!TestCase.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (DiscoveryTestSuite.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz.getAnnotation(NoDiscovery.class) != null) {
            return true;
        }
        int modifiers = clazz.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            return true;
        }
        return !Modifier.isPublic(modifiers);
    }
}

