/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.nebula.widgets.compositetable.timeeditor;

import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.nebula.widgets.compositetable.day.ICalendarableItemControl;
import org.eclipse.swt.nebula.widgets.compositetable.timeeditor.ModelObject;

public class CalendarableItem
extends ModelObject {
    private static final String PROP_DATE = "date";
    public static final String PROP_TOOL_TIP_TEXT = "toolTipText";
    public static final String PROP_DATA = "data";
    public static final String PROP_TEXT = "text";
    public static final String PROP_IMAGE = "image";
    public static final String PROP_END_TIME = "endTime";
    public static final String PROP_START_TIME = "startTime";
    public static final String PROP_ALL_DAY_EVENT = "allDayEvent";
    public static final String PROP_CONTINUED = "continued";
    public static final Comparator comparator = new Comparator(){

        public int compare(Object c1, Object c2) {
            CalendarableItem cal1 = (CalendarableItem)c1;
            CalendarableItem cal2 = (CalendarableItem)c2;
            if (cal1.isAllDayEvent()) {
                if (cal2.isAllDayEvent()) {
                    return 0;
                }
                return -1;
            }
            if (cal2.isAllDayEvent()) {
                return 1;
            }
            return cal1.getStartTime().compareTo(cal2.getStartTime());
        }
    };
    private boolean allDayEvent = false;
    private Date startTime = new Date();
    private Date endTime = new Date();
    private Image image;
    private String text = null;
    private String toolTipText;
    private Object data = null;
    private Map dataMap = new HashMap();
    private Point upperLeftPositionInDayRowCoordinates = null;
    private Point lowerRightPositionInDayRowCoordinates = null;
    private ICalendarableItemControl control = null;
    private int continued;
    public static final String BINDING_KEY = "BindingBinding";
    public static final String DATA_KEY = "BindingData";

    public CalendarableItem(Date day) {
        this.setDate(day);
    }

    public boolean isAllDayEvent() {
        return this.allDayEvent;
    }

    public void setAllDayEvent(boolean allDayEvent) {
        boolean oldValue = this.allDayEvent;
        this.allDayEvent = allDayEvent;
        this.firePropertyChange(PROP_ALL_DAY_EVENT, oldValue, allDayEvent);
    }

    public Date getDate() {
        return this.startTime;
    }

    public void setDate(Date date) {
        Date oldValue = this.startTime;
        this.startTime = this.setDateComponentOf(date, this.startTime);
        this.endTime = this.setDateComponentOf(date, this.endTime);
        this.firePropertyChange(PROP_DATE, oldValue, this.startTime);
    }

    private Date setDateComponentOf(Date source, Date into) {
        GregorianCalendar mergeSource = new GregorianCalendar();
        mergeSource.setTime(source);
        GregorianCalendar mergeTarget = new GregorianCalendar();
        mergeTarget.setTime(into);
        mergeTarget.set(2, mergeSource.get(2));
        mergeTarget.set(5, mergeSource.get(5));
        mergeTarget.set(1, mergeSource.get(1));
        return mergeTarget.getTime();
    }

    private Date setTimeComponentOf(Date source, Date into) {
        GregorianCalendar mergeSource = new GregorianCalendar();
        mergeSource.setTime(source);
        GregorianCalendar mergeTarget = new GregorianCalendar();
        mergeTarget.setTime(into);
        mergeTarget.set(9, mergeSource.get(9));
        mergeTarget.set(10, mergeSource.get(10));
        mergeTarget.set(12, mergeSource.get(12));
        mergeTarget.set(13, mergeSource.get(13));
        mergeTarget.set(14, mergeSource.get(14));
        return mergeTarget.getTime();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        if (startTime == null && this.isAllDayEvent()) {
            return;
        }
        Date oldValue = this.startTime;
        this.startTime = this.setTimeComponentOf(startTime, this.startTime);
        this.firePropertyChange(PROP_START_TIME, oldValue, startTime);
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        if (endTime == null && this.isAllDayEvent()) {
            return;
        }
        Date oldValue = this.endTime;
        this.endTime = this.setTimeComponentOf(endTime, this.endTime);
        this.firePropertyChange(PROP_END_TIME, oldValue, endTime);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        Image oldValue = this.image;
        this.image = image;
        if (this.control != null) {
            this.control.setImage(image);
        }
        this.firePropertyChange(PROP_IMAGE, oldValue, image);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        String oldValue = this.text;
        this.text = string;
        if (this.control != null) {
            this.control.setText(string);
        }
        this.firePropertyChange(PROP_TEXT, oldValue, this.text);
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String string) {
        String oldValue = this.toolTipText;
        this.toolTipText = string;
        if (this.control != null) {
            this.control.setToolTipText(string);
        }
        this.firePropertyChange(PROP_TOOL_TIP_TEXT, oldValue, this.toolTipText);
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        Object oldValue = this.data;
        this.data = data;
        this.firePropertyChange(PROP_DATA, oldValue, data);
    }

    public void setData(String key, Object data) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.dataMap.put(key, data);
    }

    public Object getData(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        return this.dataMap.get(key);
    }

    public Point getUpperLeftPositionInDayRowCoordinates() {
        return this.upperLeftPositionInDayRowCoordinates;
    }

    public void setUpperLeftPositionInDayRowCoordinates(Point upperLeftPositionInDayRowCoordinates) {
        this.upperLeftPositionInDayRowCoordinates = upperLeftPositionInDayRowCoordinates;
        if (this.lowerRightPositionInDayRowCoordinates == null) {
            this.lowerRightPositionInDayRowCoordinates = upperLeftPositionInDayRowCoordinates;
        }
    }

    public Point getLowerRightPositionInDayRowCoordinates() {
        return this.lowerRightPositionInDayRowCoordinates;
    }

    public void setLowerRightPositionInDayRowCoordinates(Point lowerRightPositionInDayRowCoordinates) {
        this.lowerRightPositionInDayRowCoordinates = lowerRightPositionInDayRowCoordinates;
    }

    public ICalendarableItemControl getControl() {
        return this.control;
    }

    public void setControl(ICalendarableItemControl control) {
        if (control == null) {
            this.control.setCalendarableItem(null);
        }
        this.control = control;
        if (control != null) {
            control.setCalendarableItem(this);
            control.setContinued(this.continued);
        }
    }

    public void setContinued(int continued) {
        this.continued = continued;
        if (this.control != null) {
            this.control.setContinued(continued);
        }
    }

    public int getContinued() {
        return this.continued;
    }
}

