/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db.h2;

import java.sql.Driver;
import javax.sql.DataSource;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.spi.db.DBAdapter;
import org.h2.jdbcx.JdbcDataSource;

public class H2Adapter
extends DBAdapter {
    private static final String NAME = "h2";
    public static final String VERSION = "1.1.114";

    public H2Adapter() {
        super(NAME, VERSION);
    }

    public Driver getJDBCDriver() {
        return new org.h2.Driver();
    }

    public DataSource createJDBCDataSource() {
        return new JdbcDataSource();
    }

    protected String getTypeName(IDBField field) {
        DBType type = field.getType();
        switch (type) {
            case BIT: {
                return "SMALLINT";
            }
            case FLOAT: {
                return "REAL";
            }
            case LONGVARCHAR: {
                return "VARCHAR";
            }
            case NUMERIC: {
                return "DECIMAL";
            }
            case VARBINARY: 
            case LONGVARBINARY: {
                return "BLOB";
            }
        }
        return super.getTypeName(field);
    }

    public String[] getReservedWords() {
        return this.getSQL92ReservedWords();
    }
}

