/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp.ssl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMPlatform;

public class SSLProperties {
    public static final String KEY_PATH = "org.eclipse.net4j.tcp.ssl.key";
    public static final String TRUST_PATH = "org.eclipse.net4j.tcp.ssl.trust";
    public static final String PASS_PHRASE = "org.eclipse.net4j.tcp.ssl.passphrase";
    public static final String HANDSHAKE_TIMEOUT = "org.eclipse.net4j.tcp.ssl.handshake.timeout";
    public static final String HANDSHAKE_WAITTIME = "org.eclipse.net4j.tcp.ssl.handshake.waittime";
    private Properties localProperties;

    public void load(String localConfigPath) throws IOException {
        this.localProperties = new Properties();
        InputStream in = null;
        try {
            try {
                in = new URL(localConfigPath).openStream();
                this.localProperties.load(in);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex, (String)"SSL config cannot be loaded");
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close((Closeable)in);
    }

    public String getKeyPath() {
        String keyPath = OMPlatform.INSTANCE.getProperty(KEY_PATH);
        if (keyPath == null && this.localProperties != null) {
            keyPath = this.localProperties.getProperty(KEY_PATH);
        }
        return keyPath;
    }

    public String getTrustPath() {
        String trustPath = OMPlatform.INSTANCE.getProperty(TRUST_PATH);
        if (trustPath == null && this.localProperties != null) {
            trustPath = this.localProperties.getProperty(TRUST_PATH);
        }
        return trustPath;
    }

    public String getPassPhrase() {
        String passPhrase = OMPlatform.INSTANCE.getProperty(PASS_PHRASE);
        if (passPhrase == null && this.localProperties != null) {
            passPhrase = this.localProperties.getProperty(PASS_PHRASE);
        }
        return passPhrase;
    }

    public String getHandShakeTimeOut() {
        String hsTimeOut = OMPlatform.INSTANCE.getProperty(HANDSHAKE_TIMEOUT);
        if (hsTimeOut == null && this.localProperties != null) {
            hsTimeOut = this.localProperties.getProperty(HANDSHAKE_TIMEOUT);
        }
        return hsTimeOut;
    }

    public String getHandShakeWaitTime() {
        String waitTime = OMPlatform.INSTANCE.getProperty(HANDSHAKE_WAITTIME);
        if (waitTime == null && this.localProperties != null) {
            waitTime = this.localProperties.getProperty(HANDSHAKE_WAITTIME);
        }
        return waitTime;
    }
}

