/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.om;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.net4j.internal.util.bundle.AbstractBundle;
import org.eclipse.net4j.internal.util.bundle.AbstractPlatform;
import org.eclipse.net4j.util.WrappedException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiBundle
extends AbstractBundle {
    public OSGiBundle(AbstractPlatform platform, String bundleID, Class<?> accessor) {
        super(platform, bundleID, accessor);
    }

    public BundleContext getBundleContext() {
        return (BundleContext)super.getBundleContext();
    }

    @Override
    public URL getBaseURL() {
        try {
            URL entry = this.getBundleContext().getBundle().getEntry("/");
            URL baseURL = FileLocator.resolve((URL)entry);
            String str = baseURL.toExternalForm();
            if (str.endsWith("/./")) {
                baseURL = new URL(str.substring(0, str.length() - 2));
            }
            return baseURL;
        }
        catch (IOException ex) {
            throw WrappedException.wrap(ex);
        }
    }

    @Override
    public Iterator<Class<?>> getClasses() {
        Bundle bundle = this.getBundleContext().getBundle();
        return new AbstractIterator<Class<?>>(bundle){
            private Enumeration<String> entryPaths;
            {
                this.entryPaths = bundle.getEntryPaths("/");
            }

            @Override
            protected Object computeNextElement() {
                while (this.entryPaths.hasMoreElements()) {
                    String entryPath = this.entryPaths.nextElement();
                    Class c = OSGiBundle.this.getClassFromBundle(entryPath);
                    if (c == null) continue;
                    return c;
                }
                return END_OF_DATA;
            }
        };
    }

    @Override
    public String getStateLocation() {
        Bundle bundle = this.getBundleContext().getBundle();
        return Platform.getStateLocation((Bundle)bundle).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractIterator<T>
    implements Iterator<T> {
        protected static final Object END_OF_DATA = new Object();
        private boolean computed;
        private T next;

        @Override
        public final boolean hasNext() {
            if (this.computed) {
                return true;
            }
            Object object = this.computeNextElement();
            this.computed = true;
            if (object == END_OF_DATA) {
                return false;
            }
            Object cast = object;
            this.next = cast;
            return true;
        }

        @Override
        public final T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.computed = false;
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract Object computeNextElement();
    }
}

