/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.om;

import org.eclipse.core.runtime.Platform;
import org.eclipse.net4j.internal.util.bundle.AbstractPlatform;
import org.eclipse.net4j.internal.util.om.OSGiBundle;
import org.eclipse.net4j.util.om.OMBundle;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiPlatform
extends AbstractPlatform {
    BundleContext systemContext;

    public OSGiPlatform(Object systemContext) {
        this.systemContext = (BundleContext)systemContext;
        try {
            this.setDebugging(Platform.inDebugMode());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean isOSGiRunning() {
        return true;
    }

    @Override
    public String getProperty(String key) {
        return this.systemContext != null ? this.systemContext.getProperty(key) : null;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String property = this.getProperty(key);
        return property != null ? property : defaultValue;
    }

    @Override
    protected OMBundle createBundle(String bundleID, Class<?> accessor) {
        return new OSGiBundle(this, bundleID, accessor);
    }

    @Override
    protected String getDebugOption(String bundleID, String option) {
        try {
            DebugOptions debugOptions = this.getDebugOptions();
            return debugOptions.getOption(String.valueOf(bundleID) + "/" + option);
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    @Override
    protected void setDebugOption(String bundleID, String option, String value) {
        try {
            DebugOptions debugOptions = this.getDebugOptions();
            debugOptions.setOption(String.valueOf(bundleID) + "/" + option, value);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected DebugOptions getDebugOptions() throws NoClassDefFoundError, NullPointerException {
        ServiceReference ref = this.systemContext.getServiceReference(DebugOptions.class.getName());
        return (DebugOptions)this.systemContext.getService(ref);
    }
}

