/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.om.pref;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.internal.util.om.pref.Preference;
import org.eclipse.net4j.internal.util.om.pref.Preferences;
import org.eclipse.net4j.util.om.pref.OMPreference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayPreference
extends Preference<String[]> {
    private static final String SEPARATOR = ",";
    private static final String UTF_8 = "UTF-8";

    public ArrayPreference(Preferences preferences, String name, String[] defaultValue) {
        super(preferences, name, defaultValue);
    }

    @Override
    protected String getString() {
        String[] array = (String[])this.getValue();
        if (array == null || array.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (builder.length() != 0) {
                builder.append(SEPARATOR);
                builder.append(" ");
            }
            try {
                String encoded = URLEncoder.encode(element, UTF_8);
                builder.append(encoded);
            }
            catch (UnsupportedEncodingException ex) {
                OM.LOG.error(ex);
                return null;
            }
            ++n2;
        }
        return builder.toString();
    }

    @Override
    protected String[] convert(String value) {
        String[] array = value.split(SEPARATOR);
        if (array == null || array.length == 0) {
            return Preferences.DEFAULT_ARRAY;
        }
        int i = 0;
        while (i < array.length) {
            try {
                array[i] = URLDecoder.decode(array[i].trim(), UTF_8);
            }
            catch (UnsupportedEncodingException ex) {
                OM.LOG.error(ex);
                return null;
            }
            ++i;
        }
        return array;
    }

    @Override
    public OMPreference.Type getType() {
        return OMPreference.Type.ARRAY;
    }
}

