/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.net4j.util.container.ContainerDelta;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.container.IContainerEventVisitor;
import org.eclipse.net4j.util.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerEvent<E>
extends Event
implements IContainerEvent<E> {
    private static final long serialVersionUID = 1L;
    private List<IContainerDelta<E>> deltas;

    public ContainerEvent(IContainer<E> container) {
        super(container);
        this.deltas = new ArrayList<IContainerDelta<E>>();
    }

    public ContainerEvent(IContainer<E> container, List<IContainerDelta<E>> deltas) {
        super(container);
        this.deltas = deltas;
    }

    @Override
    public IContainer<E> getSource() {
        return (IContainer)super.getSource();
    }

    @Override
    public boolean isEmpty() {
        return this.deltas.isEmpty();
    }

    @Override
    public IContainerDelta<E>[] getDeltas() {
        return this.deltas.toArray(new IContainerDelta[this.deltas.size()]);
    }

    @Override
    public IContainerDelta<E> getDelta() throws IllegalStateException {
        if (this.deltas.size() != 1) {
            throw new IllegalStateException("deltas.size() != 1");
        }
        return this.deltas.get(0);
    }

    @Override
    public E getDeltaElement() throws IllegalStateException {
        return this.getDelta().getElement();
    }

    @Override
    public IContainerDelta.Kind getDeltaKind() throws IllegalStateException {
        return this.getDelta().getKind();
    }

    public void addDelta(E element, IContainerDelta.Kind kind) {
        this.addDelta(new ContainerDelta<E>(element, kind));
    }

    public void addDelta(IContainerDelta<E> delta) {
        this.deltas.add(delta);
    }

    @Override
    public void accept(IContainerEventVisitor<E> visitor) {
        for (IContainerDelta<E> delta : this.deltas) {
            E element = delta.getElement();
            boolean filtered = true;
            if (visitor instanceof IContainerEventVisitor.Filtered) {
                filtered = ((IContainerEventVisitor.Filtered)visitor).filter(element);
            }
            if (!filtered) continue;
            switch (delta.getKind()) {
                case ADDED: {
                    visitor.added(element);
                    break;
                }
                case REMOVED: {
                    visitor.removed(element);
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        IContainerDelta<E>[] iContainerDeltaArray = this.getDeltas();
        int n = iContainerDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContainerDelta<E> delta = iContainerDeltaArray[n2];
            builder.append(", ");
            builder.append((Object)delta.getKind());
            builder.append("=");
            builder.append(delta.getElement());
            ++n2;
        }
        return MessageFormat.format("ContainerEvent[source={0}{1}]", this.getSource(), builder.toString());
    }
}

