/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.compiler.adaptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.objectteams.otdt.core.ext.OTDTPlugin;
import org.eclipse.objectteams.otdt.internal.compiler.adaptor.AdaptedBaseBundle;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.RequiredPluginsClasspathContainer;
import org.objectteams.LiftingVetoException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectBindingReader {
    private static final String ASPECT_BINDING = "aspectBinding";
    private static final String BASE_PLUGIN = "basePlugin";
    private static final String ID = "id";
    private static final String FORCED_EXPORTS = "forcedExports";
    private static final String TEAM = "team";
    private static final String CLASS = "class";
    private static final String SELF = "SELF";
    private static SAXParserFactory fSAXFactory;
    private HashMap<String, HashSet<String>> team2basePlugins = null;
    private HashMap<String, HashSet<String>> base2forcedExports = null;
    private HashSet<String> teamsAdaptingSelf = new HashSet();
    private HashMap<String, AdaptedBaseBundle> adaptationInfos = new HashMap();
    private String project;
    private IProject iProject;
    Object token;
    private boolean hasChanges;
    PluginModelManager fPluginModelManager;

    public AspectBindingReader(IProject project) throws LiftingVetoException {
        if (!this.readAspectBindings(project, AspectBindingReader.getSaxParserFactory())) {
            throw new LiftingVetoException();
        }
        this.project = project.getName();
        this.iProject = project;
        this.fPluginModelManager = PDECore.getDefault().getModelManager();
    }

    public boolean isAdaptingSelf(String teamName) {
        return this.teamsAdaptingSelf.contains(teamName);
    }

    public Set<String> getBasePlugins(String teamName) {
        if (this.team2basePlugins != null) {
            return this.team2basePlugins.get(teamName);
        }
        return null;
    }

    public boolean isAdaptedBase(String symbolicName) {
        return this.adaptationInfos.containsKey(symbolicName);
    }

    public Set<String> getTeamsForBase(String basePluginName) {
        AdaptedBaseBundle info = this.adaptationInfos.get(basePluginName);
        if (info == null) {
            return new HashSet<String>();
        }
        return info.adaptingTeams;
    }

    public AdaptedBaseBundle getAdaptationInfo(String basePluginName) {
        AdaptedBaseBundle result = this.adaptationInfos.get(basePluginName);
        if (result == null) {
            result = new AdaptedBaseBundle(basePluginName, this);
            this.adaptationInfos.put(basePluginName, result);
        }
        return result;
    }

    public String getForcedExportingBase(String packageName) {
        if (this.base2forcedExports == null) {
            return null;
        }
        for (Map.Entry<String, HashSet<String>> entry : this.base2forcedExports.entrySet()) {
            if (!entry.getValue().contains(packageName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public HashSet<String> getForcedExports(String symbolicName) {
        if (this.base2forcedExports == null) {
            return null;
        }
        return this.base2forcedExports.get(symbolicName);
    }

    static SAXParserFactory getSaxParserFactory() {
        if (fSAXFactory == null) {
            fSAXFactory = SAXParserFactory.newInstance();
        }
        return fSAXFactory;
    }

    private boolean readAspectBindings(IProject project, SAXParserFactory factory) {
        IFile file;
        SAXParser parser;
        block3: {
            parser = factory.newSAXParser();
            file = project.getFile("plugin.xml");
            if (file.exists()) break block3;
            return false;
        }
        try {
            this.collectAspectBindings(file, parser);
            this.token = new Object();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    void recordAspectBinding(String teamClass, String basePluginID) {
        HashSet<String> plugins;
        if (SELF.equals(basePluginID.toUpperCase())) {
            this.teamsAdaptingSelf.add(teamClass);
            return;
        }
        if (this.team2basePlugins == null) {
            this.team2basePlugins = new HashMap();
        }
        if ((plugins = this.team2basePlugins.get(teamClass)) == null) {
            plugins = new HashSet();
            this.team2basePlugins.put(teamClass, plugins);
        }
        plugins.add(basePluginID);
        AdaptedBaseBundle adaptationInfo = this.getAdaptationInfo(basePluginID);
        adaptationInfo.adaptingTeams.add(teamClass);
    }

    void recordForcedExports(String basePlugin, String exports) {
        HashSet<String> baseExports;
        if (this.base2forcedExports == null) {
            this.base2forcedExports = new HashMap();
        }
        if ((baseExports = this.base2forcedExports.get(basePlugin)) == null) {
            baseExports = new HashSet();
            this.base2forcedExports.put(basePlugin, baseExports);
        }
        String[] singleExports = exports.split(",");
        int i = 0;
        while (i < singleExports.length) {
            baseExports.add(singleExports[i].trim());
            ++i;
        }
    }

    void collectAspectBindings(IFile file, SAXParser parser) {
        try {
            parser.parse(file.getContents(), new DefaultHandler(){
                String basePluginID = null;
                ArrayList<String> teamClasses = null;
                StringBuffer forcedExports = null;

                public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                    if (name.equals(AspectBindingReader.ASPECT_BINDING)) {
                        this.teamClasses = new ArrayList();
                    } else if (this.teamClasses != null) {
                        if (name.equals(AspectBindingReader.BASE_PLUGIN)) {
                            this.basePluginID = attributes.getValue(AspectBindingReader.ID);
                        } else if (name.equals(AspectBindingReader.TEAM)) {
                            String teamClass = attributes.getValue(AspectBindingReader.CLASS);
                            if (teamClass == null) {
                                throw new SAXException("team element lacking \"class\" attribute");
                            }
                            this.teamClasses.add(teamClass);
                        } else if (name.equals(AspectBindingReader.FORCED_EXPORTS)) {
                            this.forcedExports = new StringBuffer();
                        }
                    }
                }

                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.forcedExports != null) {
                        this.forcedExports.append(ch, start, length);
                    }
                }

                public void endElement(String uri, String localName, String name) throws SAXException {
                    if (name.equals(AspectBindingReader.ASPECT_BINDING)) {
                        if (this.basePluginID == null) {
                            throw new SAXException("aspectBinding missing a \"basePlugin\" element");
                        }
                        for (String teamClass : this.teamClasses) {
                            AspectBindingReader.this.recordAspectBinding(teamClass, this.basePluginID);
                        }
                        this.basePluginID = null;
                        this.teamClasses = null;
                    } else if (name.equals(AspectBindingReader.FORCED_EXPORTS)) {
                        if (this.forcedExports != null && this.forcedExports.length() > 0) {
                            AspectBindingReader.this.recordForcedExports(this.basePluginID, this.forcedExports.toString());
                        }
                        this.forcedExports = null;
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void reload() {
        this.hasChanges = true;
        HashMap<String, HashSet<String>> oldForcedExports = this.base2forcedExports;
        HashMap<String, HashSet<String>> oldTeamBindings = this.team2basePlugins;
        this.team2basePlugins = null;
        this.base2forcedExports = null;
        this.adaptationInfos.clear();
        this.teamsAdaptingSelf.clear();
        if (!this.readAspectBindings(this.iProject, AspectBindingReader.getSaxParserFactory())) {
            OTDTPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.objectteams.otdt", "Unable to re-read plugin.xml!;"));
            return;
        }
        if (this.mapHasChanged(oldForcedExports, this.base2forcedExports) || this.mapHasChanged(oldTeamBindings, this.team2basePlugins)) {
            this.resetRequiredPluginsClasspathContainer(this.iProject);
        }
    }

    boolean fetchHasChanges() {
        try {
            boolean bl = this.hasChanges;
            return bl;
        }
        finally {
            this.hasChanges = false;
        }
    }

    private void resetRequiredPluginsClasspathContainer(IProject project) {
        IJavaProject jProject = JavaCore.create((IProject)project);
        IPluginModelBase model = this.fPluginModelManager.findModel(project);
        try {
            IBuild build = ClasspathUtilCore.getBuild((IPluginModelBase)model);
            RequiredPluginsClasspathContainer container = new RequiredPluginsClasspathContainer(model, build);
            JavaCore.setClasspathContainer((IPath)PDECore.REQUIRED_PLUGINS_CONTAINER_PATH, (IJavaProject[])new IJavaProject[]{jProject}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
        catch (CoreException ce) {
            OTDTPlugin.logException((String)("Failed to reload classpath container for " + project), (Throwable)ce);
        }
    }

    private <T> boolean mapHasChanged(HashMap<String, T> oldMap, HashMap<String, T> newMap) {
        if (oldMap == null || newMap == null) {
            return oldMap != newMap;
        }
        HashSet<String> newKeys = new HashSet<String>(newMap.keySet());
        for (Map.Entry<String, T> oldEntry : oldMap.entrySet()) {
            T newVal = newMap.get(oldEntry.getKey());
            if (newVal == null) {
                return true;
            }
            if (!newVal.equals(oldEntry.getValue())) {
                return true;
            }
            newKeys.remove(oldEntry.getKey());
        }
        return !newKeys.isEmpty();
    }

    public String toString() {
        String result = "AspectBindingReader for project " + this.project;
        if (this.team2basePlugins != null) {
            result = String.valueOf(result) + "\n\t known teams: " + this.team2basePlugins.size();
        }
        if (this.teamsAdaptingSelf != null) {
            result = String.valueOf(result) + "\n\t self-adaption teams: " + this.teamsAdaptingSelf.size();
        }
        if (this.base2forcedExports != null) {
            result = String.valueOf(result) + "\n\t plugins with forced exports: " + this.base2forcedExports.size();
        }
        return result;
    }
}

