/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventFilter;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jdt.debug.core.IJavaBreakpointListener;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.objectteams.otdt.debug.IOTDebugEventListener;
import org.eclipse.objectteams.otdt.debug.TeamBreakpointInstaller;
import org.eclipse.objectteams.otdt.debug.internal.Logger;
import org.eclipse.objectteams.otdt.debug.internal.OTDebugElementsContainerFactory;
import org.eclipse.objectteams.otdt.debug.internal.RoleBreakpointListener;
import org.eclipse.objectteams.otdt.debug.internal.StepFromLinenumberGenerator;
import org.eclipse.objectteams.otdt.debug.internal.TeamBreakpointListener;
import org.eclipse.objectteams.otdt.debug.internal.TempFileManager;
import org.osgi.framework.BundleContext;

public class OTDebugPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.objectteams.otdt.debug";
    public static final String OT_LAUNCH = "org.eclipse.objectteams.launch";
    private OTDebugElementsContainerFactory _containerFactory;
    private static OTDebugPlugin plugin;
    private OTDebugLaunchManager _otLaunchManager;
    private TeamBreakpointListener _otTeamBreakpointListener;
    private RoleBreakpointListener _otRoleBreakpointListener;
    private IOTDebugEventListener[] _listeners = new IOTDebugEventListener[0];
    private TempFileManager _tempFileManager;
    private StepFromLinenumberGenerator _stepGenerator;
    private String _callinSteppingConfig = null;

    private void otLaunchFinished(ILaunch launch) {
        if (this._tempFileManager != null) {
            this._tempFileManager.deleteTempFile(launch);
        }
    }

    public OTDebugPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this._otLaunchManager = new OTDebugLaunchManager();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this._otLaunchManager);
    }

    public void stop(BundleContext context) throws Exception {
        this.unregisterOTDebugSupport();
        this._otLaunchManager.terminateOTLaunches();
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this._otLaunchManager);
        this._otLaunchManager = null;
        if (this._tempFileManager != null) {
            this._tempFileManager.deleteAll();
            this._tempFileManager = null;
        }
        super.stop(context);
    }

    public static OTDebugPlugin getDefault() {
        return plugin;
    }

    public void setCallinSteppingConfig(String config) {
        this._callinSteppingConfig = config;
    }

    public String getCallinSteppingConfig() {
        return this._callinSteppingConfig;
    }

    public static IStatus createErrorStatus(String message) {
        return new Status(4, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, 0, message, exception);
    }

    public static void logException(String message, Throwable exception) {
        plugin.getLog().log(OTDebugPlugin.createErrorStatus(message, exception));
    }

    TempFileManager getTempFileManager() {
        if (this._tempFileManager == null) {
            this._tempFileManager = new TempFileManager();
        }
        return this._tempFileManager;
    }

    public IOTDebugEventListener[] getOTDebugEventListeners() {
        return this._listeners;
    }

    public void addOTDebugEventListener(IOTDebugEventListener listener) {
        int newLength = this._listeners.length + 1;
        IOTDebugEventListener[] newListeners = new IOTDebugEventListener[newLength];
        System.arraycopy(this._listeners, 0, newListeners, 0, this._listeners.length);
        newListeners[this._listeners.length] = listener;
        this._listeners = newListeners;
    }

    public void removeOTDebugEventListener(IOTDebugEventListener listener) {
        int occurrences = 0;
        int i = 0;
        while (i < this._listeners.length) {
            if (listener.equals(this._listeners[i])) {
                ++occurrences;
            }
            ++i;
        }
        if (occurrences > 0) {
            int newLength = this._listeners.length - occurrences;
            IOTDebugEventListener[] newListeners = new IOTDebugEventListener[newLength];
            int insertionIndex = 0;
            int i2 = 0;
            while (i2 < this._listeners.length) {
                if (!listener.equals(this._listeners[i2])) {
                    newListeners[insertionIndex++] = this._listeners[i2];
                }
                ++i2;
            }
            this._listeners = newListeners;
        }
    }

    private void checkRegisterOTDebugSupport(int otLaunchCount) {
        if (otLaunchCount <= 0) {
            this.unregisterOTDebugSupport();
        } else if (this._otTeamBreakpointListener == null) {
            this.registerOTDebugSupport();
        }
    }

    private void registerOTDebugSupport() {
        assert (this._otTeamBreakpointListener == null);
        this._containerFactory = new OTDebugElementsContainerFactory();
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)this._containerFactory, ILaunch.class);
        this._otTeamBreakpointListener = TeamBreakpointListener.getInstance();
        this._otRoleBreakpointListener = RoleBreakpointListener.getInstance();
        this._stepGenerator = StepFromLinenumberGenerator.getInstance();
        DebugPlugin.getDefault().addDebugEventFilter((IDebugEventFilter)this._stepGenerator);
        JDIDebugPlugin.getDefault().addJavaBreakpointListener((IJavaBreakpointListener)this._otTeamBreakpointListener);
        JDIDebugPlugin.getDefault().addJavaBreakpointListener((IJavaBreakpointListener)this._otRoleBreakpointListener);
    }

    private void unregisterOTDebugSupport() {
        if (this._otTeamBreakpointListener != null) {
            DebugPlugin.getDefault().removeDebugEventFilter((IDebugEventFilter)this._stepGenerator);
            JDIDebugPlugin.getDefault().removeJavaBreakpointListener((IJavaBreakpointListener)this._otTeamBreakpointListener);
            JDIDebugPlugin.getDefault().removeJavaBreakpointListener((IJavaBreakpointListener)this._otRoleBreakpointListener);
            try {
                TeamBreakpointInstaller.uninstallTeamBreakpoints();
            }
            catch (CoreException coreException) {
                Logger.log(0, "OTDebugPlugin.unregisterOTDebugSupport()", "ERROR unable to remove Breakpoints");
            }
            this._otTeamBreakpointListener.dispose();
            this._otTeamBreakpointListener = null;
            this._otRoleBreakpointListener.dispose();
            this._otRoleBreakpointListener = null;
        }
        if (this._containerFactory != null) {
            this._containerFactory.dispose();
        }
        this._containerFactory = null;
    }

    class OTDebugLaunchManager
    implements ILaunchesListener2 {
        private Vector<ILaunch> _otLaunches;

        public OTDebugLaunchManager() {
            ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
            if (launches != null) {
                this._otLaunches = new Vector();
                int i = 0;
                while (i < launches.length) {
                    if (this.isOTDebugLaunch(launches[i])) {
                        this._otLaunches.add(launches[i]);
                    }
                    ++i;
                }
                OTDebugPlugin.this.checkRegisterOTDebugSupport(this._otLaunches.size());
            }
        }

        public void terminateOTLaunches() {
            Object[] launches = new ILaunch[this._otLaunches.size()];
            this._otLaunches.copyInto(launches);
            int i = 0;
            while (i < launches.length) {
                try {
                    launches[i].terminate();
                }
                catch (DebugException ex) {
                    OTDebugPlugin.logException("Unable to terminate launch on bundle shutdown", ex);
                }
                ++i;
            }
        }

        public int getOTLaunchesCount() {
            return this._otLaunches.size();
        }

        private boolean isOTDebugLaunch(ILaunch launch) {
            block4: {
                block5: {
                    try {
                        if (!"debug".equals(launch.getLaunchMode())) break block4;
                        String isOTLaunch = launch.getAttribute(OTDebugPlugin.OT_LAUNCH);
                        if (isOTLaunch == null || !isOTLaunch.equals("true")) break block5;
                        return true;
                    }
                    catch (CoreException coreException) {}
                }
                if (launch.getLaunchConfiguration() != null) {
                    return launch.getLaunchConfiguration().getAttribute(OTDebugPlugin.OT_LAUNCH, false);
                }
            }
            return false;
        }

        public void launchesAdded(ILaunch[] launches) {
            int idx = 0;
            while (idx < launches.length) {
                ILaunch launch = launches[idx];
                if (this.isOTDebugLaunch(launch) && !this._otLaunches.contains(launch)) {
                    this._otLaunches.add(launch);
                    OTDebugPlugin.this.checkRegisterOTDebugSupport(this._otLaunches.size());
                }
                ++idx;
            }
        }

        public void launchesTerminated(ILaunch[] launches) {
            this.forgetOTLaunches(launches);
        }

        private void forgetOTLaunches(ILaunch[] launches) {
            int idx = 0;
            while (idx < launches.length) {
                ILaunch launch = launches[idx];
                if (this.isOTDebugLaunch(launch) && this._otLaunches.contains(launch)) {
                    this._otLaunches.remove(launch);
                    OTDebugPlugin.this.checkRegisterOTDebugSupport(this._otLaunches.size());
                    OTDebugPlugin.this.otLaunchFinished(launch);
                }
                ++idx;
            }
            assert (this._otLaunches.size() >= 0);
        }

        public void launchesRemoved(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }
    }
}

