/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.refactoring.otrefactorings.inlinecallin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractMethodMappingDeclaration;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BaseCallMessageSend;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CallinMappingDeclaration;
import org.eclipse.jdt.core.dom.CalloutMappingDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodSpec;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ParameterMapping;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.objectteams.otdt.core.ICallinMapping;
import org.eclipse.objectteams.otdt.core.ICalloutMapping;
import org.eclipse.objectteams.otdt.core.ICalloutToFieldMapping;
import org.eclipse.objectteams.otdt.core.IMethodMapping;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.refactoring.corext.rename.BaseCallFinder;
import org.eclipse.objectteams.otdt.internal.refactoring.otrefactorings.OTRefactoringMessages;
import org.eclipse.objectteams.otdt.internal.refactoring.otrefactorings.inlinecallin.CallinBaseMethodInfo;
import org.eclipse.objectteams.otdt.internal.refactoring.util.RefactoringUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineCallinRefactoring
extends Refactoring {
    private IMethod fRoleMethod;
    private String fRoleMethodName;
    private CallinBaseMethodInfo[] fCallinBaseMethodInfos;
    private boolean fDeleteRoleMethod;
    private CompilationUnit fRootBase;
    private AST fBaseAST;
    private ImportRewrite fBaseImportRewriter;
    private ICompilationUnit fBaseCUnit;
    private CallinBaseMethodInfo[] fTargetBaseMethods;
    private ICompilationUnit fRoleCUnit;
    private CompilationUnit fRootRole;
    private AST fRoleAST;
    private IType fRoleType;
    private TextFileChange fBaseTextFileChange;
    private TextFileChange fRoleTextFileChange;
    private List<ICallinMapping> fBoundCallinMappings;
    private IType fBaseType;
    private ASTRewrite fBaseRewrite;
    private ASTRewrite fRoleRewrite;
    private Object fCachedBaseMethodInfo = null;
    private Set<String> fCachedTunneledParameters = null;

    public InlineCallinRefactoring() {
    }

    public InlineCallinRefactoring(IMethod roleMethod) {
        this.fRoleMethod = roleMethod;
    }

    public InlineCallinRefactoring(IMethod roleMethod, ICallinMapping[] callinMapping, IMethod[] baseMethods) {
        this.fBaseType = baseMethods[0].getDeclaringType();
        ArrayList<CallinBaseMethodInfo> methodInfos = new ArrayList<CallinBaseMethodInfo>();
        int i = 0;
        while (i < baseMethods.length) {
            methodInfos.add(new CallinBaseMethodInfo(baseMethods[i], callinMapping[i]));
            ++i;
        }
        this.setBaseMethods(methodInfos.toArray(new CallinBaseMethodInfo[methodInfos.size()]));
        this.fRoleMethod = roleMethod;
    }

    public IMethod getRoleMethod() {
        return this.fRoleMethod;
    }

    public IMethod[] getBoundBaseMethods() throws JavaModelException {
        ArrayList<IMethod> boundBaseMethods = new ArrayList<IMethod>();
        for (ICallinMapping mapping : this.fBoundCallinMappings) {
            boundBaseMethods.addAll(Arrays.asList(mapping.getBoundBaseMethods()));
        }
        return boundBaseMethods.toArray(new IMethod[boundBaseMethods.size()]);
    }

    public List<ICallinMapping> getBoundCallinMappings() {
        return this.fBoundCallinMappings;
    }

    public String getName() {
        return OTRefactoringMessages.InlineCallin_inlineCallin_name;
    }

    public void setRoleMethodName(String name) {
        this.fRoleMethodName = name;
    }

    public CallinBaseMethodInfo[] getBaseMethodInfos() {
        return this.fCallinBaseMethodInfos;
    }

    public void setBaseMethods(CallinBaseMethodInfo[] baseMethods) {
        this.fTargetBaseMethods = baseMethods;
    }

    public void setDeleteRoleMethod(boolean deleteRoleMethod) {
        this.fDeleteRoleMethod = deleteRoleMethod;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask(OTRefactoringMessages.InlineCallinRefactoring_preconditions_progress, 1);
            if (this.fRoleMethod == null) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)OTRefactoringMessages.InlineCallinRefactoring_noMethod_error));
            } else if (!this.fRoleMethod.exists()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.InlineCallinRefactoring_inexistentMethod_error, (Object[])new Object[]{this.fRoleMethod.getElementName()})));
            } else if (this.fRoleMethod.isBinary()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.InlineCallinRefactoring_binaryMethod_error, (Object[])new Object[]{this.fRoleMethod.getElementName()})));
            } else if (this.fRoleMethod.isReadOnly()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.InlineCallinRefactoring_readOnlyMethod_error, (Object[])new Object[]{this.fRoleMethod.getElementName()})));
            } else if (!this.fRoleMethod.getCompilationUnit().isStructureKnown()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.InlineCallinRefactoring_compileErrors_error, (Object[])new Object[]{this.fRoleMethod.getCompilationUnit().getElementName()})));
            } else if (!RefactoringUtil.isRoleMethod(this.fRoleMethod)) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.InlineCallinRefactoring_notInsideRole_error, (Object[])new Object[]{this.fRoleMethod.getElementName()})));
            } else {
                status.merge(this.initialize(monitor));
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private RefactoringStatus initialize(IProgressMonitor monitor) {
        RefactoringStatus status = new RefactoringStatus();
        this.fRoleMethodName = this.fRoleMethod.getElementName();
        this.fRoleType = this.fRoleMethod.getDeclaringType();
        this.fRoleCUnit = this.fRoleMethod.getCompilationUnit();
        if (this.fRootRole == null) {
            this.fRootRole = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fRoleCUnit, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 99));
        }
        this.fRoleAST = this.fRootRole.getAST();
        try {
            IType baseType = ((IRoleType)OTModelManager.getOTElement((IType)this.fRoleMethod.getDeclaringType())).getBaseClass();
            if (baseType != null) {
                if (baseType.isBinary()) {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.InlineCallinRefactoring_binaryBase_error, (Object)baseType.getElementName())));
                    return status;
                }
                if (baseType.isReadOnly()) {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.InlineCallinRefactoring_readOnlyBase_error, (Object)baseType.getElementName())));
                    return status;
                }
                this.fBaseType = baseType;
                this.fBaseCUnit = baseType.getCompilationUnit();
                if (this.fRootBase == null) {
                    this.fRootBase = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fBaseCUnit, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 99));
                }
                this.fBaseImportRewriter = StubUtility.createImportRewrite((CompilationUnit)this.fRootBase, (boolean)true);
                this.fBaseAST = this.fRootBase.getAST();
            } else {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)OTRefactoringMessages.InlineCallinRefactoring_unboundRole_error));
            }
        }
        catch (JavaModelException javaModelException) {
            status.merge(this.createCouldNotParseStatus());
        }
        if (status.hasFatalError()) {
            return status;
        }
        IMethodMapping[] callinMappings = ((IRoleType)OTModelManager.getOTElement((IType)this.fRoleType)).getMethodMappings(1);
        this.fBoundCallinMappings = new ArrayList<ICallinMapping>();
        int i = 0;
        while (i < callinMappings.length) {
            if (callinMappings[i].getRoleMethod().equals(this.fRoleMethod)) {
                this.fBoundCallinMappings.add((ICallinMapping)callinMappings[i]);
            }
            ++i;
        }
        if (this.fBoundCallinMappings.size() == 0) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)OTRefactoringMessages.InlineCallinRefactoring_unboundMethod_error, (Object[])new Object[]{this.fRoleMethod.getElementName()})));
        }
        ArrayList<CallinBaseMethodInfo> infos = new ArrayList<CallinBaseMethodInfo>();
        for (ICallinMapping mapping : this.fBoundCallinMappings) {
            try {
                IMethod[] iMethodArray = mapping.getBoundBaseMethods();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method = iMethodArray[n2];
                    infos.add(new CallinBaseMethodInfo(method, mapping));
                    ++n2;
                }
                this.fCallinBaseMethodInfos = infos.toArray(new CallinBaseMethodInfo[infos.size()]);
            }
            catch (JavaModelException javaModelException) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)OTRefactoringMessages.InlineCallinRefactoring_unparseableMethodMapping_error));
            }
        }
        return status;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        status.merge(this.checkBaseMethods());
        if (status.hasFatalError()) {
            return status;
        }
        status.merge(this.generateNewBaseMethodNames());
        status.merge(this.checkRoleMethodName());
        status.merge(this.checkDependenciesToRole(pm));
        status.merge(this.checkRoleMethodReferences(pm));
        return status;
    }

    private RefactoringStatus checkRoleMethodReferences(IProgressMonitor pm) throws CoreException {
        final HashSet references = new HashSet();
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)this.fRoleMethod, (int)2, (int)0);
        SearchEngine engine = new SearchEngine();
        engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                if (match.getAccuracy() == 0 && !match.isInsideDocComment()) {
                    references.add(match);
                }
            }
        }, pm);
        RefactoringStatus status = new RefactoringStatus();
        ArrayList<ICallinMapping> inlinedCallins = new ArrayList<ICallinMapping>();
        int i = 0;
        while (i < this.fCallinBaseMethodInfos.length) {
            inlinedCallins.add(this.fCallinBaseMethodInfos[i].getCallinMapping());
            ++i;
        }
        for (SearchMatch match : references) {
            Object element = match.getElement();
            if (element instanceof ICallinMapping) {
                ICallinMapping mapping = (ICallinMapping)element;
                if (mapping.getRoleMethod().equals(this.fRoleMethod)) {
                    if (inlinedCallins.contains(mapping)) {
                        continue;
                    }
                } else {
                    status.addError(NLS.bind((String)OTRefactoringMessages.InlineCallinRefactoring_methodBoundByOtherCallin_error, (Object)this.fRoleMethod.getElementName()));
                    continue;
                }
            }
            if (element instanceof ICalloutMapping) {
                status.addError(NLS.bind((String)OTRefactoringMessages.InlineCallinRefactoring_methodIsCallout_error, (Object)this.fRoleMethod.getElementName()));
                continue;
            }
            if (!this.fDeleteRoleMethod) continue;
            if (element instanceof IMember) {
                IMember referencingMember = (IMember)element;
                String msg = NLS.bind((String)OTRefactoringMessages.InlineCallinRefactoring_methodIsUsedBy_error, (Object)this.fRoleMethod.getElementName(), (Object)JavaElementLabels.getTextLabel((Object)referencingMember, (long)JavaElementLabels.ALL_FULLY_QUALIFIED));
                status.addError(msg, JavaStatusContext.create((IMember)referencingMember));
                continue;
            }
            status.addError(NLS.bind((String)OTRefactoringMessages.InlineCallinRefactoring_methodIsUsed_error, (Object)this.fRoleMethod.getElementName()));
        }
        return status;
    }

    private RefactoringStatus checkMethodName(String name) {
        String complianceLevel;
        RefactoringStatus result = new RefactoringStatus();
        if (name == null) {
            return RefactoringStatus.createFatalErrorStatus((String)OTRefactoringMessages.InlineCallinRefactoring_missingNewMethodName_error);
        }
        if ("".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)OTRefactoringMessages.InlineCallinRefactoring_emptyMethodName_error);
        }
        IJavaProject javaProject = this.fRoleType.getJavaProject();
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        IStatus status = JavaConventions.validateMethodName((String)name, (String)sourceLevel, (String)(complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true)));
        if (status.isOK()) {
            return result;
        }
        switch (status.getSeverity()) {
            case 4: {
                return RefactoringStatus.createFatalErrorStatus((String)status.getMessage());
            }
            case 2: {
                return RefactoringStatus.createWarningStatus((String)status.getMessage());
            }
            case 1: {
                return RefactoringStatus.createInfoStatus((String)status.getMessage());
            }
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkIfMethodExists() {
        try {
            if (this.methodWithNameExists(this.fBaseType, this.fRoleMethodName)) {
                return RefactoringStatus.createErrorStatus((String)NLS.bind((String)OTRefactoringMessages.InlineCallinRefactoring_methodNameClash_error, (Object)this.fRoleMethodName));
            }
        }
        catch (JavaModelException javaModelException) {
            return this.createCouldNotParseStatus();
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkDependenciesToRole(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus status = new RefactoringStatus();
        IMethod[] referencedMethods = ReferenceFinderUtil.getMethodsReferencedIn((IJavaElement[])new IJavaElement[]{this.fRoleMethod}, null, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        int i = 0;
        while (i < referencedMethods.length) {
            IMethod referencedMethod = referencedMethods[i];
            if (referencedMethod.getDeclaringType().equals(this.fRoleType)) {
                status.merge(RefactoringStatus.createErrorStatus((String)NLS.bind((String)OTRefactoringMessages.InlineCallinRefactoring_methodUsesRoleMethod_error, (Object)this.fRoleMethodName, (Object)referencedMethod)));
            }
            ++i;
        }
        IField[] referencedFileds = ReferenceFinderUtil.getFieldsReferencedIn((IJavaElement[])new IJavaElement[]{this.fRoleMethod}, null, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        int i2 = 0;
        while (i2 < referencedFileds.length) {
            IField referencedFiled = referencedFileds[i2];
            if (referencedFiled.getDeclaringType().equals(this.fRoleType)) {
                status.merge(RefactoringStatus.createErrorStatus((String)NLS.bind((String)OTRefactoringMessages.InlineCallinRefactoring_methodUsesRoleField_error, (Object)this.fRoleMethodName, (Object)referencedFiled)));
            }
            ++i2;
        }
        return status;
    }

    RefactoringStatus checkRoleMethodName() {
        RefactoringStatus status = new RefactoringStatus();
        status.merge(this.checkIfMethodExists());
        status.merge(this.checkMethodName(this.fRoleMethodName));
        return status;
    }

    RefactoringStatus checkBaseMethods() {
        RefactoringStatus status = new RefactoringStatus();
        if (this.fTargetBaseMethods == null || this.fTargetBaseMethods.length == 0) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)OTRefactoringMessages.InlineCallinRefactoring_missingBaseMethod_error));
        }
        return status;
    }

    private boolean methodWithNameExists(IType type, String methodName) throws JavaModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.getElementName().equals(methodName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private RefactoringStatus createCouldNotParseStatus() {
        return RefactoringStatus.createFatalErrorStatus((String)OTRefactoringMessages.InlineCallinRefactoring_unparseableType_error);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask(OTRefactoringMessages.InlineCallinRefactoring_creatingChange_progress, this.fCallinBaseMethodInfos.length + 2);
        this.inlineCallin(pm);
        CompositeChange change = new CompositeChange(this.getName(), (Change[])new TextFileChange[]{this.fBaseTextFileChange, this.fRoleTextFileChange});
        pm.done();
        return change;
    }

    private void inlineCallin(IProgressMonitor pm) throws CoreException {
        this.fBaseRewrite = ASTRewrite.create((AST)this.fBaseAST);
        this.fRoleRewrite = ASTRewrite.create((AST)this.fRoleAST);
        int i = 0;
        while (i < this.fTargetBaseMethods.length) {
            IMethod baseMethod = this.fTargetBaseMethods[i].getMethod();
            CallinBaseMethodInfo methodInfo = this.fTargetBaseMethods[i];
            this.renameBaseMethod(methodInfo);
            MethodDeclaration wrapperMethodDeclaration = this.createWrapperMethod(methodInfo);
            Statement roleMethodInvocation = this.createRoleMethodInvocation(methodInfo);
            List statements = wrapperMethodDeclaration.getBody().statements();
            switch (methodInfo.getCallinMapping().getCallinKind()) {
                case 1: {
                    statements.add(0, roleMethodInvocation);
                    break;
                }
                case 2: {
                    if (!baseMethod.getReturnType().equals(Character.toString('V'))) {
                        statements.clear();
                        MethodDeclaration baseMethodDeclaration = RefactoringUtil.methodToDeclaration(baseMethod, this.fRootBase);
                        String varName = this.generateResultVarName(methodInfo);
                        VariableDeclarationFragment fragment = this.fBaseAST.newVariableDeclarationFragment();
                        fragment.setName(this.fBaseAST.newSimpleName(varName));
                        fragment.setInitializer((Expression)this.createBaseMethodInvocation(methodInfo));
                        VariableDeclarationStatement variableDeclarationStatement = this.fBaseAST.newVariableDeclarationStatement(fragment);
                        variableDeclarationStatement.setType((Type)ASTNode.copySubtree((AST)this.fBaseAST, (ASTNode)baseMethodDeclaration.getReturnType2()));
                        statements.add(variableDeclarationStatement);
                        statements.add(roleMethodInvocation);
                        ReturnStatement returnStatement = this.fBaseAST.newReturnStatement();
                        returnStatement.setExpression((Expression)this.fBaseAST.newSimpleName(varName));
                        statements.add(returnStatement);
                        break;
                    }
                    statements.add(roleMethodInvocation);
                    break;
                }
                case 3: {
                    statements.clear();
                    statements.add(roleMethodInvocation);
                    break;
                }
            }
            this.insertMethodIntoBase(wrapperMethodDeclaration, baseMethod);
            pm.worked(1);
            ++i;
        }
        this.adjustMethodMappings();
        pm.worked(1);
        this.copyRoleMethodToBase(this.fTargetBaseMethods[0]);
        pm.worked(1);
        if (this.fDeleteRoleMethod) {
            this.deleteRoleMethod();
        }
        MultiTextEdit baseMultiEdit = new MultiTextEdit();
        baseMultiEdit.addChild(this.fBaseRewrite.rewriteAST());
        this.fBaseTextFileChange = new TextFileChange(this.fBaseCUnit.getElementName(), (IFile)this.fBaseCUnit.getResource());
        this.fBaseTextFileChange.setTextType("java");
        this.fBaseTextFileChange.setEdit((TextEdit)baseMultiEdit);
        if (this.fBaseImportRewriter.hasRecordedChanges()) {
            TextEdit edit = this.fBaseImportRewriter.rewriteImports(null);
            baseMultiEdit.addChild(edit);
            this.fBaseTextFileChange.addTextEditGroup(new TextEditGroup(OTRefactoringMessages.OTRefactoring_organizeImports_editName, new TextEdit[]{edit}));
        }
        MultiTextEdit roleMultiEdit = new MultiTextEdit();
        roleMultiEdit.addChild(this.fRoleRewrite.rewriteAST());
        this.fRoleTextFileChange = new TextFileChange(this.fRoleCUnit.getElementName(), (IFile)this.fRoleCUnit.getResource());
        this.fRoleTextFileChange.setTextType("java");
        this.fRoleTextFileChange.setEdit((TextEdit)roleMultiEdit);
    }

    private void renameBaseMethod(CallinBaseMethodInfo baseMethodInfo) throws JavaModelException {
        MethodDeclaration baseMethodDeclaration = RefactoringUtil.methodToDeclaration(baseMethodInfo.getMethod(), this.fRootBase);
        this.fBaseRewrite.set((ASTNode)baseMethodDeclaration, (StructuralPropertyDescriptor)MethodDeclaration.NAME_PROPERTY, (Object)this.fBaseAST.newSimpleName(baseMethodInfo.getNewMethodName()), null);
    }

    private MethodDeclaration createWrapperMethod(CallinBaseMethodInfo baseMethodInfo) throws CoreException {
        MethodDeclaration baseMethodDeclaration = RefactoringUtil.methodToDeclaration(baseMethodInfo.getMethod(), this.fRootBase);
        MethodDeclaration methodDeclaration = (MethodDeclaration)ASTNode.copySubtree((AST)this.fBaseAST, (ASTNode)baseMethodDeclaration);
        methodDeclaration.setBody(this.createMethodBody(baseMethodInfo));
        return methodDeclaration;
    }

    private Block createMethodBody(CallinBaseMethodInfo baseMethodInfo) throws JavaModelException {
        Block block = this.fBaseAST.newBlock();
        List statements = block.statements();
        MethodInvocation invocation = this.createBaseMethodInvocation(baseMethodInfo);
        MethodDeclaration declaration = RefactoringUtil.methodToDeclaration(baseMethodInfo.getMethod(), this.fRootBase);
        Type type = declaration.getReturnType2();
        if (type == null || type instanceof PrimitiveType && PrimitiveType.VOID.equals(((PrimitiveType)type).getPrimitiveTypeCode())) {
            statements.add(invocation.getAST().newExpressionStatement((Expression)invocation));
        } else {
            ReturnStatement statement = invocation.getAST().newReturnStatement();
            statement.setExpression((Expression)invocation);
            statements.add(statement);
        }
        return block;
    }

    private void adjustMethodMappings() throws JavaModelException {
        HashMap<IMethod, ICallinMapping> methodToMapping = new HashMap<IMethod, ICallinMapping>();
        int i = 0;
        while (i < this.fTargetBaseMethods.length) {
            methodToMapping.put(this.fTargetBaseMethods[i].getMethod(), this.fTargetBaseMethods[i].getCallinMapping());
            ++i;
        }
        for (ICallinMapping callinMapping : methodToMapping.values()) {
            Set baseMethodsToRemove = methodToMapping.keySet();
            CallinMappingDeclaration methodMappingDecl = (CallinMappingDeclaration)RefactoringUtil.methodMappingToDeclaration((IMethodMapping)callinMapping, this.fRootRole);
            if (baseMethodsToRemove.containsAll(Arrays.asList(callinMapping.getBoundBaseMethods()))) {
                this.fRoleRewrite.remove((ASTNode)methodMappingDecl, null);
                continue;
            }
            CallinMappingDeclaration mappingDeclaration = methodMappingDecl;
            List baseMethods = mappingDeclaration.getBaseMappingElements();
            for (MethodSpec methodSpec : baseMethods) {
                for (IMethod method : baseMethodsToRemove) {
                    IMethodBinding methodBinding;
                    IMethod boundMethod;
                    if (!method.equals(boundMethod = (IMethod)(methodBinding = methodSpec.resolveBinding()).getJavaElement())) continue;
                    this.fRoleRewrite.remove((ASTNode)methodSpec, null);
                }
            }
        }
    }

    private void deleteRoleMethod() throws JavaModelException {
        AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)RefactoringUtil.typeToDeclaration(this.fRoleType, this.fRootRole);
        ChildListPropertyDescriptor descriptor = this.typeToBodyDeclarationProperty(this.fBaseType, this.fRootBase);
        MethodDeclaration roleMethodDecl = RefactoringUtil.methodToDeclaration(this.fRoleMethod, this.fRootRole);
        this.fRoleRewrite.getListRewrite((ASTNode)declaration, descriptor).remove((ASTNode)roleMethodDecl, null);
    }

    private boolean hasResultTunneling(CallinBaseMethodInfo baseMethodInfo) throws JavaModelException {
        if (baseMethodInfo.getCallinMapping().getCallinKind() != 3) {
            return false;
        }
        if (this.isVoidMethod(baseMethodInfo.getMethod())) {
            return false;
        }
        if (!this.isVoidMethod(this.fRoleMethod)) {
            return false;
        }
        return !this.hasResultParameterMapping(baseMethodInfo.getCallinMapping());
    }

    private boolean hasResultParameterMapping(ICallinMapping callinMapping) throws JavaModelException {
        if (!this.hasParameterMapping((IMethodMapping)callinMapping)) {
            return false;
        }
        AbstractMethodMappingDeclaration mappingDecl = RefactoringUtil.methodMappingToDeclaration((IMethodMapping)callinMapping, this.fRootRole);
        List parameterMappings = mappingDecl.getParameterMappings();
        for (ParameterMapping parameterMapping : parameterMappings) {
            if (!parameterMapping.hasResultFlag()) continue;
            return true;
        }
        return false;
    }

    private Statement createRoleMethodInvocation(CallinBaseMethodInfo baseMethodInfo) throws JavaModelException {
        MethodInvocation invocation = this.fBaseAST.newMethodInvocation();
        ICallinMapping callinMapping = baseMethodInfo.getCallinMapping();
        invocation.setName(this.fBaseAST.newSimpleName(this.fRoleMethodName));
        CallinMappingDeclaration callinMappingDecl = (CallinMappingDeclaration)RefactoringUtil.methodMappingToDeclaration((IMethodMapping)callinMapping, this.fRootRole);
        if (this.hasParameterMapping((IMethodMapping)callinMapping)) {
            this.copyRoleParameterMappingsToInvocation(invocation, callinMappingDecl, baseMethodInfo);
        } else {
            String[] parameterNames = baseMethodInfo.getMethod().getParameterNames();
            int length = callinMapping.getCallinKind() == 3 ? parameterNames.length : this.fRoleMethod.getParameterNames().length;
            this.copyInvocationParameters(invocation, parameterNames, length);
        }
        if (this.needsReturnStatement(baseMethodInfo)) {
            ReturnStatement statement = invocation.getAST().newReturnStatement();
            statement.setExpression((Expression)invocation);
            return statement;
        }
        return invocation.getAST().newExpressionStatement((Expression)invocation);
    }

    private boolean needsReturnStatement(CallinBaseMethodInfo baseMethodInfo) throws JavaModelException {
        if (this.isReplace(baseMethodInfo)) {
            return !this.isVoidMethod(baseMethodInfo.getMethod());
        }
        return !this.isVoidMethod(this.fRoleMethod) && !this.isVoidMethod(baseMethodInfo.getMethod());
    }

    private boolean isVoidMethod(IMethod method) throws JavaModelException {
        return method.getReturnType().equals(Character.toString('V'));
    }

    private void copyRoleParameterMappingsToInvocation(MethodInvocation invocation, CallinMappingDeclaration callinMappingDecl, CallinBaseMethodInfo baseMethodInfo) throws JavaModelException {
        MethodSpec baseMethodSpec = this.findBaseMethodSpec(callinMappingDecl, baseMethodInfo.getMethod());
        List baseMappingParams = baseMethodSpec.parameters();
        HashMap<String, String> callinParamNamesToBaseMethodParamNames = new HashMap<String, String>();
        String[] names = baseMethodInfo.getMethod().getParameterNames();
        int i = 0;
        while (i < names.length) {
            callinParamNamesToBaseMethodParamNames.put(((SingleVariableDeclaration)baseMappingParams.get(i)).getName().getIdentifier(), names[i]);
            ++i;
        }
        List paramMappings = callinMappingDecl.getParameterMappings();
        MethodSpec roleMethodSpec = (MethodSpec)callinMappingDecl.getRoleMappingElement();
        List roleMappingParams = roleMethodSpec.parameters();
        for (SingleVariableDeclaration singleVariableDeclaration : roleMappingParams) {
            String paramName = singleVariableDeclaration.getName().getIdentifier();
            for (ParameterMapping mapping : paramMappings) {
                if (mapping.hasResultFlag() || !mapping.getIdentifier().getIdentifier().equals(paramName)) continue;
                Expression expr = (Expression)ASTNode.copySubtree((AST)this.fBaseAST, (ASTNode)mapping.getExpression());
                this.substituteBaseParams(expr, callinParamNamesToBaseMethodParamNames, baseMethodInfo);
                invocation.arguments().add(expr);
            }
        }
        if (this.isReplace(baseMethodInfo)) {
            Set<String> tunneledParams = this.findTunneledParameters(baseMethodInfo);
            for (String paramName : tunneledParams) {
                String tunneledName = this.generateTunneledParamName(paramName);
                invocation.arguments().add(this.fBaseAST.newSimpleName(tunneledName));
            }
        }
    }

    private void copyBaseParameterMappingsToInvocation(MethodInvocation invocation, CallinMappingDeclaration callinMappingDecl, CallinBaseMethodInfo baseMethodInfo) throws JavaModelException {
        int baseMethodParameterLength;
        int roleMethodParameterLength;
        MethodSpec roleMethodSpec = (MethodSpec)callinMappingDecl.getRoleMappingElement();
        List roleMappingParams = roleMethodSpec.parameters();
        HashMap<String, String> callinParamNamesToRoleMethodParamNames = new HashMap<String, String>();
        String[] roleParamNames = this.fRoleMethod.getParameterNames();
        int i = 0;
        while (i < roleParamNames.length) {
            callinParamNamesToRoleMethodParamNames.put(((SingleVariableDeclaration)roleMappingParams.get(i)).getName().getIdentifier(), roleParamNames[i]);
            ++i;
        }
        List paramMappings = callinMappingDecl.getParameterMappings();
        MethodSpec baseMethodSpec = this.findBaseMethodSpec(callinMappingDecl, baseMethodInfo.getMethod());
        List baseMappingParams = baseMethodSpec.parameters();
        HashMap<String, String> callinParamNamesToBaseMethodParamNames = new HashMap<String, String>();
        String[] baseParamNames = baseMethodInfo.getMethod().getParameterNames();
        int i2 = 0;
        while (i2 < baseParamNames.length) {
            callinParamNamesToBaseMethodParamNames.put(((SingleVariableDeclaration)baseMappingParams.get(i2)).getName().getIdentifier(), baseParamNames[i2]);
            ++i2;
        }
        HashMap<String, SimpleName> baseParamToExpression = new HashMap<String, SimpleName>();
        for (SingleVariableDeclaration singleVariableDeclaration : baseMappingParams) {
            String paramName = singleVariableDeclaration.getName().getIdentifier();
            for (ParameterMapping mapping : paramMappings) {
                SimpleName mappedName;
                if (mapping.hasResultFlag() || !(mapping.getExpression() instanceof SimpleName) || !(mappedName = (SimpleName)mapping.getExpression()).getIdentifier().equals(paramName)) continue;
                String roleMethodIdentifier = (String)callinParamNamesToRoleMethodParamNames.get(mapping.getIdentifier().getIdentifier());
                String baseMethodIdentifier = (String)callinParamNamesToBaseMethodParamNames.get(paramName);
                baseParamToExpression.put(baseMethodIdentifier, this.fBaseAST.newSimpleName(roleMethodIdentifier));
            }
        }
        String[] stringArray = baseParamNames;
        int n = baseParamNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (baseParamToExpression.get(name) == null) {
                String tunneledName = this.generateTunneledParamName(name);
                invocation.arguments().add(this.fBaseAST.newSimpleName(tunneledName));
            } else {
                invocation.arguments().add(baseParamToExpression.get(name));
            }
            ++n2;
        }
        if (this.isReplace(baseMethodInfo) && !this.hasParameterMapping((IMethodMapping)baseMethodInfo.getCallinMapping()) && (roleMethodParameterLength = baseMethodInfo.getCallinMapping().getRoleMethod().getParameterNames().length) < (baseMethodParameterLength = baseMethodInfo.getMethod().getParameterNames().length)) {
            this.appendInvocationParameters(invocation, baseMethodInfo.getMethod(), roleMethodParameterLength);
        }
    }

    private void substituteBaseParams(Expression expr, Map<String, String> callinParamNamesToBaseMethodParamNames, CallinBaseMethodInfo baseMethodInfo) throws JavaModelException {
        ArrayList<String> callinParamNames = new ArrayList<String>();
        for (String name : callinParamNamesToBaseMethodParamNames.keySet()) {
            callinParamNames.add(name);
        }
        SimpleNameFinder simpleNameFinder = new SimpleNameFinder(callinParamNames);
        expr.accept((ASTVisitor)simpleNameFinder);
        List<SimpleName> simpleNames = simpleNameFinder.getResult();
        for (SimpleName simpleName : simpleNames) {
            String baseMethodParamName = callinParamNamesToBaseMethodParamNames.get(simpleName.getIdentifier());
            simpleName.setIdentifier(baseMethodParamName);
        }
    }

    private Set<String> findTunneledParameters(CallinBaseMethodInfo baseMethodInfo) throws JavaModelException {
        if (this.fCachedBaseMethodInfo == baseMethodInfo) {
            return this.fCachedTunneledParameters;
        }
        this.fCachedBaseMethodInfo = baseMethodInfo;
        HashSet<String> tunneledParams = new HashSet<String>();
        CallinMappingDeclaration callinMappingDecl = (CallinMappingDeclaration)RefactoringUtil.methodMappingToDeclaration((IMethodMapping)baseMethodInfo.getCallinMapping(), this.fRootRole);
        MethodSpec baseMethodSpec = this.findBaseMethodSpec(callinMappingDecl, baseMethodInfo.getMethod());
        List baseMappingParams = baseMethodSpec.parameters();
        HashMap<String, String> baseMethodParamNameToBaseMappingParamName = new HashMap<String, String>();
        String[] names = baseMethodInfo.getMethod().getParameterNames();
        int i = 0;
        while (i < names.length) {
            baseMethodParamNameToBaseMappingParamName.put(names[i], ((SingleVariableDeclaration)baseMappingParams.get(i)).getName().getIdentifier());
            ++i;
        }
        List paramMappings = callinMappingDecl.getParameterMappings();
        tunneledParams.addAll(Arrays.asList(baseMethodInfo.getMethod().getParameterNames()));
        int i2 = 0;
        while (i2 < names.length) {
            for (ParameterMapping mapping : paramMappings) {
                SimpleName simpleName;
                Expression expr;
                if (mapping.hasResultFlag() || !((expr = (Expression)mapping.getExpression()) instanceof SimpleName) || !(simpleName = (SimpleName)expr).getIdentifier().equals(baseMethodParamNameToBaseMappingParamName.get(names[i2]))) continue;
                tunneledParams.remove(names[i2]);
            }
            ++i2;
        }
        this.fCachedTunneledParameters = tunneledParams;
        return this.fCachedTunneledParameters;
    }

    private void copyInvocationParameters(MethodInvocation invocation, IMethod method) throws JavaModelException {
        String[] parameterNames = method.getParameterNames();
        this.copyInvocationParameters(invocation, parameterNames, parameterNames.length);
    }

    private void copyInvocationParameters(MethodInvocation invocation, String[] names, int n) throws JavaModelException {
        int i = 0;
        while (i < n) {
            invocation.arguments().add(this.fBaseAST.newSimpleName(names[i]));
            ++i;
        }
    }

    private void copyRoleMethodToBase(CallinBaseMethodInfo baseMethodInfo) throws JavaModelException {
        MethodDeclaration roleMethodDeclaration = RefactoringUtil.methodToDeclaration(this.fRoleMethod, this.fRootRole);
        MethodDeclaration copyOfRoleMethodDeclaration = (MethodDeclaration)ASTNode.copySubtree((AST)this.fBaseAST, (ASTNode)roleMethodDeclaration);
        copyOfRoleMethodDeclaration.setName(this.fBaseAST.newSimpleName(this.fRoleMethodName));
        if (!Flags.isPrivate((int)this.fRoleMethod.getFlags()) && !Flags.isCallin((int)this.fRoleMethod.getFlags())) {
            this.changeToPrivateVisibility(this.fBaseRewrite, copyOfRoleMethodDeclaration);
        }
        if (Flags.isCallin((int)this.fRoleMethod.getFlags())) {
            this.handleCallinMethod(this.fBaseRewrite, baseMethodInfo, copyOfRoleMethodDeclaration);
        }
        if (this.isReplace(baseMethodInfo)) {
            if (this.hasParameterMapping((IMethodMapping)baseMethodInfo.getCallinMapping())) {
                this.appendTunneledParameterDeclarations(baseMethodInfo, copyOfRoleMethodDeclaration);
            } else {
                int baseMethodParameterLength;
                int roleMethodParameterLength = baseMethodInfo.getCallinMapping().getRoleMethod().getParameterNames().length;
                if (roleMethodParameterLength < (baseMethodParameterLength = baseMethodInfo.getMethod().getParameterNames().length)) {
                    this.appendParameterDeclarations(copyOfRoleMethodDeclaration, baseMethodInfo.getMethod(), roleMethodParameterLength);
                }
            }
        }
        this.findAndReplaceCallouts(this.fBaseRewrite, copyOfRoleMethodDeclaration);
        this.insertMethodIntoBase(copyOfRoleMethodDeclaration, baseMethodInfo.getMethod());
        HashSet staticImports = new HashSet();
        HashSet imports = new HashSet();
        ImportRewriteUtil.collectImports((IJavaProject)this.fRoleMethod.getJavaProject(), (ASTNode)roleMethodDeclaration, imports, staticImports, (boolean)false);
        for (ITypeBinding typeBinding : imports) {
            this.fBaseImportRewriter.addImport(typeBinding);
        }
        for (IBinding binding : staticImports) {
            this.fBaseImportRewriter.addStaticImport(binding);
        }
    }

    private void changeToPrivateVisibility(ASTRewrite astRewrite, MethodDeclaration methodDeclaration) {
        Modifier privateVisibility = methodDeclaration.getAST().newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        List modifiers = methodDeclaration.modifiers();
        for (IExtendedModifier extendedModifier : modifiers) {
            if (!(extendedModifier instanceof Modifier)) continue;
            Modifier modifier = (Modifier)extendedModifier;
            if (Modifier.isPublic((int)modifier.getKeyword().toFlagValue())) {
                astRewrite.replace((ASTNode)modifier, (ASTNode)privateVisibility, null);
                return;
            }
            if (Modifier.isProtected((int)modifier.getKeyword().toFlagValue())) {
                astRewrite.replace((ASTNode)modifier, (ASTNode)privateVisibility, null);
                return;
            }
            if (!Modifier.isPrivate((int)modifier.getKeyword().toFlagValue())) continue;
            return;
        }
        astRewrite.getListRewrite((ASTNode)methodDeclaration, MethodDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)privateVisibility, null);
    }

    private void handleCallinMethod(ASTRewrite astRewrite, CallinBaseMethodInfo baseMethodInfo, MethodDeclaration methodDeclaration) throws JavaModelException {
        List statements = methodDeclaration.getBody().statements();
        this.removeCallinFlag(methodDeclaration);
        if (this.fRoleMethod.getReturnType().equals(Character.toString('V'))) {
            ReturnFinder returnFinder = new ReturnFinder();
            methodDeclaration.accept((ASTVisitor)returnFinder);
            List<ReturnStatement> returns = returnFinder.getResult();
            for (ReturnStatement returnStatement : returns) {
                astRewrite.replace((ASTNode)returnStatement, (ASTNode)this.fBaseAST.newReturnStatement(), null);
            }
        }
        if (this.hasResultTunneling(baseMethodInfo)) {
            String varName = this.generateResultVarName(baseMethodInfo);
            VariableDeclarationFragment fragment = this.fBaseAST.newVariableDeclarationFragment();
            fragment.setName(this.fBaseAST.newSimpleName(varName));
            VariableDeclarationStatement variableDeclarationStatement = this.fBaseAST.newVariableDeclarationStatement(fragment);
            MethodDeclaration baseMethodDeclaration = RefactoringUtil.methodToDeclaration(baseMethodInfo.getMethod(), this.fRootBase);
            variableDeclarationStatement.setType((Type)ASTNode.copySubtree((AST)this.fBaseAST, (ASTNode)baseMethodDeclaration.getReturnType2()));
            statements.add(0, variableDeclarationStatement);
            ReturnStatement returnStatement = this.fBaseAST.newReturnStatement();
            returnStatement.setExpression((Expression)this.fBaseAST.newSimpleName(varName));
            statements.add(returnStatement);
            this.substituteBaseCalls(methodDeclaration, astRewrite, varName, baseMethodInfo);
        } else if (this.hasResultParameterMapping(baseMethodInfo.getCallinMapping()) && this.isVoidMethod(this.fRoleMethod)) {
            AbstractMethodMappingDeclaration mappingDecl = RefactoringUtil.methodMappingToDeclaration((IMethodMapping)baseMethodInfo.getCallinMapping(), this.fRootRole);
            List parameterMappings = mappingDecl.getParameterMappings();
            Expression resultMappingExpression = null;
            for (ParameterMapping parameterMapping : parameterMappings) {
                if (!parameterMapping.hasResultFlag()) continue;
                resultMappingExpression = (Expression)parameterMapping.getExpression();
            }
            ReturnStatement returnStatement = this.fBaseAST.newReturnStatement();
            returnStatement.setExpression((Expression)ASTNode.copySubtree((AST)this.fBaseAST, resultMappingExpression));
            statements.add(returnStatement);
            this.substituteBaseCalls(methodDeclaration, astRewrite, null, baseMethodInfo);
        } else {
            this.substituteBaseCalls(methodDeclaration, astRewrite, null, baseMethodInfo);
        }
        Modifier privateVisibility = this.fBaseAST.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        methodDeclaration.modifiers().add(privateVisibility);
        MethodDeclaration declaration = RefactoringUtil.methodToDeclaration(baseMethodInfo.getMethod(), this.fRootBase);
        methodDeclaration.setReturnType2((Type)ASTNode.copySubtree((AST)this.fBaseAST, (ASTNode)declaration.getReturnType2()));
    }

    private boolean removeCallinFlag(MethodDeclaration methodDeclaration) {
        List modifiers = methodDeclaration.modifiers();
        for (IExtendedModifier extendedModifier : modifiers) {
            Modifier modifier;
            if (!(extendedModifier instanceof Modifier) || !Modifier.isCallin((int)(modifier = (Modifier)extendedModifier).getKeyword().toFlagValue())) continue;
            modifier.delete();
            return true;
        }
        return false;
    }

    private void substituteBaseCalls(MethodDeclaration methodDeclaration, ASTRewrite astRewrite, String localStoreVarIdentifier, CallinBaseMethodInfo baseMethodInfo) throws JavaModelException {
        BaseCallFinder baseCallFinder = new BaseCallFinder();
        methodDeclaration.accept((ASTVisitor)baseCallFinder);
        BaseCallMessageSend[] baseCalls = baseCallFinder.getResult();
        if (localStoreVarIdentifier != null) {
            int i = 0;
            while (i < baseCalls.length) {
                BaseCallMessageSend basecall = baseCalls[i];
                Assignment assignment = this.fBaseAST.newAssignment();
                assignment.setLeftHandSide((Expression)this.fBaseAST.newSimpleName(localStoreVarIdentifier));
                assignment.setRightHandSide((Expression)this.createBaseMethodInvocation(baseMethodInfo));
                astRewrite.replace((ASTNode)basecall, (ASTNode)assignment, null);
                ++i;
            }
        } else {
            int i = 0;
            while (i < baseCalls.length) {
                BaseCallMessageSend basecall = baseCalls[i];
                astRewrite.replace((ASTNode)basecall, (ASTNode)this.createBaseMethodInvocation(baseMethodInfo), null);
                ++i;
            }
        }
    }

    private void findAndReplaceCallouts(ASTRewrite astRewrite, MethodDeclaration copyOfRoleMethodDeclaration) throws JavaModelException {
        ICalloutToFieldMapping calloutToFieldMapping;
        MethodInvocationFinder methodInvocationFinder = new MethodInvocationFinder();
        copyOfRoleMethodDeclaration.accept((ASTVisitor)methodInvocationFinder);
        List<MethodInvocation> methodInvocations = methodInvocationFinder.getResult();
        IMethodMapping[] calloutMappings = ((IRoleType)OTModelManager.getOTElement((IType)this.fRoleType)).getMethodMappings(2);
        HashMap<String, Object> calloutNameToMapping = new HashMap<String, Object>();
        IMethodMapping[] iMethodMappingArray = calloutMappings;
        int n = calloutMappings.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodMapping methodMapping = iMethodMappingArray[n2];
            if (methodMapping instanceof ICalloutMapping) {
                ICalloutMapping calloutMapping = (ICalloutMapping)methodMapping;
                calloutNameToMapping.put(calloutMapping.getRoleMethodHandle().getSelector(), calloutMapping);
            }
            if (methodMapping instanceof ICalloutToFieldMapping) {
                calloutToFieldMapping = (ICalloutToFieldMapping)methodMapping;
                calloutNameToMapping.put(calloutToFieldMapping.getRoleMethodHandle().getSelector(), calloutToFieldMapping);
            }
            ++n2;
        }
        for (MethodInvocation invocation : methodInvocations) {
            IMethodMapping mapping = (IMethodMapping)calloutNameToMapping.get(invocation.getName().getIdentifier());
            if (mapping == null) continue;
            switch (mapping.getMappingKind()) {
                case 103: {
                    ICalloutMapping calloutMapping = (ICalloutMapping)mapping;
                    invocation.setName(this.fBaseAST.newSimpleName(calloutMapping.getBoundBaseMethod().getElementName()));
                    break;
                }
                case 104: {
                    calloutToFieldMapping = (ICalloutToFieldMapping)mapping;
                    CalloutMappingDeclaration calloutDecl = (CalloutMappingDeclaration)RefactoringUtil.methodMappingToDeclaration((IMethodMapping)calloutToFieldMapping, this.fRootRole);
                    String fieldName = calloutToFieldMapping.getBoundBaseField().getElementName();
                    if (Modifier.isSet((int)calloutDecl.bindingOperator().getBindingModifier())) {
                        Assignment setAssignment = this.fBaseAST.newAssignment();
                        setAssignment.setLeftHandSide((Expression)this.fBaseAST.newSimpleName(fieldName));
                        Expression setExpression = (Expression)ASTNode.copySubtree((AST)this.fBaseAST, (ASTNode)((Expression)invocation.arguments().get(0)));
                        setAssignment.setRightHandSide(setExpression);
                        astRewrite.replace((ASTNode)invocation, (ASTNode)setAssignment, null);
                        break;
                    }
                    astRewrite.replace((ASTNode)invocation, (ASTNode)this.fBaseAST.newSimpleName(fieldName), null);
                    break;
                }
            }
        }
    }

    private MethodInvocation createBaseMethodInvocation(CallinBaseMethodInfo baseMethodInfo) throws JavaModelException {
        MethodInvocation invocation = this.fBaseAST.newMethodInvocation();
        invocation.setName(this.fBaseAST.newSimpleName(baseMethodInfo.getNewMethodName()));
        if (this.isReplace(baseMethodInfo)) {
            if (!this.hasParameterMapping((IMethodMapping)baseMethodInfo.getCallinMapping())) {
                this.copyInvocationParameters(invocation, baseMethodInfo.getCallinMapping().getRoleMethod());
                int roleMethodParameterLength = baseMethodInfo.getCallinMapping().getRoleMethod().getParameterNames().length;
                int baseMethodParameterLength = baseMethodInfo.getMethod().getParameterNames().length;
                if (roleMethodParameterLength < baseMethodParameterLength) {
                    this.appendInvocationParameters(invocation, baseMethodInfo.getMethod(), roleMethodParameterLength);
                }
            } else {
                CallinMappingDeclaration callinMappingDecl = (CallinMappingDeclaration)RefactoringUtil.methodMappingToDeclaration((IMethodMapping)baseMethodInfo.getCallinMapping(), this.fRootRole);
                this.copyBaseParameterMappingsToInvocation(invocation, callinMappingDecl, baseMethodInfo);
            }
        } else {
            this.copyInvocationParameters(invocation, baseMethodInfo.getMethod());
        }
        return invocation;
    }

    private boolean isReplace(CallinBaseMethodInfo baseMethodInfo) {
        return baseMethodInfo.getCallinMapping().getCallinKind() == 3;
    }

    private boolean hasParameterMapping(IMethodMapping mapping) throws JavaModelException {
        AbstractMethodMappingDeclaration decl = RefactoringUtil.methodMappingToDeclaration(mapping, this.fRootRole);
        return decl.hasParameterMapping();
    }

    private void insertMethodIntoBase(MethodDeclaration methodDeclaration, IMethod baseMethod) throws JavaModelException {
        AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)RefactoringUtil.typeToDeclaration(this.fBaseType, this.fRootBase);
        ChildListPropertyDescriptor descriptor = this.typeToBodyDeclarationProperty(this.fBaseType, this.fRootBase);
        MethodDeclaration baseMethodDeclaration = RefactoringUtil.methodToDeclaration(baseMethod, this.fRootBase);
        this.fBaseRewrite.getListRewrite((ASTNode)declaration, descriptor).insertBefore((ASTNode)methodDeclaration, (ASTNode)baseMethodDeclaration, null);
    }

    private void appendParameterDeclarations(MethodDeclaration roleMethodDeclaration, IMethod baseMethod, int offset) throws JavaModelException {
        MethodDeclaration baseMethodDecl = RefactoringUtil.methodToDeclaration(baseMethod, this.fRootBase);
        List baseParamDeclarations = baseMethodDecl.parameters();
        int i = offset;
        while (i < baseParamDeclarations.size()) {
            SingleVariableDeclaration paramDecl = (SingleVariableDeclaration)ASTNode.copySubtree((AST)this.fBaseAST, (ASTNode)((ASTNode)baseParamDeclarations.get(i)));
            ArrayList<String> localVarNames = new ArrayList<String>();
            localVarNames.addAll(this.localVarNamesInRoleMethod());
            localVarNames.addAll(Arrays.asList(this.fRoleMethod.getParameterNames()));
            String validParameterName = this.generateVarName(paramDecl.getName().getIdentifier(), localVarNames);
            paramDecl.setName(this.fBaseAST.newSimpleName(validParameterName));
            this.fBaseRewrite.getListRewrite((ASTNode)roleMethodDeclaration, MethodDeclaration.PARAMETERS_PROPERTY).insertLast((ASTNode)paramDecl, null);
            ++i;
        }
    }

    private void appendTunneledParameterDeclarations(CallinBaseMethodInfo baseMethodInfo, MethodDeclaration copyOfRoleMethodDeclaration) throws JavaModelException {
        Set<String> tunneledParams = this.findTunneledParameters(baseMethodInfo);
        MethodDeclaration baseMethodDecl = RefactoringUtil.methodToDeclaration(baseMethodInfo.getMethod(), this.fRootBase);
        List baseParamDeclarations = baseMethodDecl.parameters();
        ListRewrite listRewrite = this.fBaseRewrite.getListRewrite((ASTNode)copyOfRoleMethodDeclaration, MethodDeclaration.PARAMETERS_PROPERTY);
        for (SingleVariableDeclaration varDecl : baseParamDeclarations) {
            String paramName = varDecl.getName().getIdentifier();
            if (!tunneledParams.contains(paramName)) continue;
            String tunneledName = this.generateTunneledParamName(paramName);
            SingleVariableDeclaration paramDecl = (SingleVariableDeclaration)ASTNode.copySubtree((AST)this.fBaseAST, (ASTNode)varDecl);
            paramDecl.setName(this.fBaseAST.newSimpleName(tunneledName));
            listRewrite.insertLast((ASTNode)paramDecl, null);
        }
    }

    private void appendInvocationParameters(MethodInvocation invocation, IMethod method, int offset) throws JavaModelException {
        String[] names = method.getParameterNames();
        int i = offset;
        while (i < names.length) {
            String name = names[i];
            ArrayList<String> localVarNames = new ArrayList<String>();
            localVarNames.addAll(this.localVarNamesInRoleMethod());
            localVarNames.addAll(Arrays.asList(this.fRoleMethod.getParameterNames()));
            String validParameterName = this.generateVarName(name, localVarNames);
            invocation.arguments().add(this.fBaseAST.newSimpleName(validParameterName));
            ++i;
        }
    }

    private RefactoringStatus generateNewBaseMethodNames() {
        try {
            this.generateBaseMethodNames(this.fTargetBaseMethods);
        }
        catch (JavaModelException javaModelException) {
            return this.createCouldNotParseStatus();
        }
        return new RefactoringStatus();
    }

    private String generateResultVarName(CallinBaseMethodInfo baseMethodInfo) throws JavaModelException {
        String name = "baseResult";
        List<String> paramNames = Arrays.asList(baseMethodInfo.getMethod().getParameterNames());
        return this.generateVarName(name, paramNames);
    }

    private String generateVarName(String desiredName, List<String> localVarNames) {
        String varName = desiredName;
        int i = 2;
        while (this.fBaseType.getField(varName).exists() || localVarNames.contains(varName)) {
            varName = String.valueOf(desiredName) + i;
            ++i;
        }
        return varName;
    }

    private void generateBaseMethodNames(CallinBaseMethodInfo[] baseMethodInfos) throws JavaModelException {
        int i = 0;
        while (i < baseMethodInfos.length) {
            String newBaseName = "base_" + this.fTargetBaseMethods[i].getMethod().getElementName();
            int j = 2;
            while (this.methodWithNameExists(this.fBaseType, newBaseName)) {
                newBaseName = "base_" + this.fTargetBaseMethods[i].getMethod().getElementName() + j;
                ++j;
            }
            baseMethodInfos[i].setNewMethodName(newBaseName);
            ++i;
        }
    }

    private String generateTunneledParamName(String identifier) throws JavaModelException {
        String upperCasedName = String.valueOf(identifier.substring(0, 1).toUpperCase()) + identifier.substring(1);
        ArrayList<String> localVarNames = new ArrayList<String>();
        localVarNames.addAll(this.localVarNamesInRoleMethod());
        localVarNames.addAll(Arrays.asList(this.fRoleMethod.getParameterNames()));
        String tunneledName = this.generateVarName("tunneled" + upperCasedName, localVarNames);
        return tunneledName;
    }

    private List<String> localVarNamesInRoleMethod() throws JavaModelException {
        ArrayList<String> localVars = new ArrayList();
        MethodDeclaration declaration = RefactoringUtil.methodToDeclaration(this.fRoleMethod, this.fRootRole);
        LocalVariableFinder localVariableFinder = new LocalVariableFinder();
        declaration.accept((ASTVisitor)localVariableFinder);
        localVars = localVariableFinder.getResult();
        return localVars;
    }

    private MethodSpec findBaseMethodSpec(CallinMappingDeclaration callinMappingDecl, IMethod baseMethod) {
        MethodSpec baseMethodSpec = null;
        List methodSpecs = callinMappingDecl.getBaseMappingElements();
        for (MethodSpec methodSpec : methodSpecs) {
            IMethodBinding methodBinding = methodSpec.resolveBinding();
            IMethod method = (IMethod)methodBinding.getJavaElement();
            if (!method.equals(baseMethod)) continue;
            baseMethodSpec = methodSpec;
        }
        return baseMethodSpec;
    }

    private ChildListPropertyDescriptor typeToBodyDeclarationProperty(IType type, CompilationUnit node) throws JavaModelException {
        ASTNode result = RefactoringUtil.typeToDeclaration(type, node);
        if (result instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)result).getBodyDeclarationsProperty();
        }
        if (result instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalVariableFinder
    extends ASTVisitor {
        private List<String> _locals = new ArrayList<String>();

        private LocalVariableFinder() {
        }

        public boolean visit(VariableDeclarationFragment node) {
            this._locals.add(node.getName().getIdentifier());
            return false;
        }

        public List<String> getResult() {
            return this._locals;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodInvocationFinder
    extends ASTVisitor {
        private List<MethodInvocation> _methodInvocations = new ArrayList<MethodInvocation>();

        private MethodInvocationFinder() {
        }

        public boolean visit(MethodInvocation node) {
            this._methodInvocations.add(node);
            return false;
        }

        public List<MethodInvocation> getResult() {
            return this._methodInvocations;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReturnFinder
    extends ASTVisitor {
        private List<ReturnStatement> _returns = new ArrayList<ReturnStatement>();

        private ReturnFinder() {
        }

        public boolean visit(ReturnStatement node) {
            this._returns.add(node);
            return false;
        }

        public List<ReturnStatement> getResult() {
            return this._returns;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleNameFinder
    extends ASTVisitor {
        private List<SimpleName> _simpleNames = new ArrayList<SimpleName>();
        private List<String> _identifier;

        public SimpleNameFinder(List<String> identifier) {
            this._identifier = identifier;
        }

        public boolean visit(SimpleName node) {
            if (this._identifier.contains(node.getIdentifier())) {
                this._simpleNames.add(node);
            }
            return false;
        }

        public List<SimpleName> getResult() {
            return this._simpleNames;
        }
    }
}

