/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.callinmarkers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.AbstractMarkable;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.CallinMarkerRemover;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.MySubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMarkable
extends AbstractMarkable {
    IResource fResource;

    public ResourceMarkable(IResource resource) {
        this.fResource = resource;
    }

    @Override
    public String getName() {
        return this.fResource.getName();
    }

    @Override
    public Set<IType> getAllTypes(IJavaProject[] projects, IProgressMonitor monitor) throws CoreException {
        HashSet<IType> result = new HashSet<IType>(13);
        IJavaElement element = JavaCore.create((IResource)this.fResource);
        if (element instanceof ICompilationUnit) {
            HashSet<IType> members = new HashSet<IType>(5);
            HashSet<IType> supers = new HashSet<IType>(5);
            IType[] iTypeArray = ((ICompilationUnit)element).getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                members.add(type);
                this.addSuperAndMemberTypes(members, supers, type, JavaCore.create((IProject)this.fResource.getProject()), projects, monitor);
                ++n2;
            }
            result.addAll(members);
            result.addAll(supers);
            monitor.worked(5);
            result.addAll(this.getSubTypes(members, (IProgressMonitor)new MySubProgressMonitor(monitor, 5)));
        }
        return result;
    }

    @Override
    IJavaProject[] getProjects() throws JavaModelException {
        return this.getProjects(this.fResource);
    }

    @Override
    public void removeCallinMarkers() throws CoreException {
        CallinMarkerRemover.removeCallinMarkers(this.fResource);
    }

    @Override
    public IJavaElement getJavaElement() {
        return JavaCore.create((IResource)this.fResource);
    }

    @Override
    public IResource getResource() {
        return this.fResource;
    }

    @Override
    boolean containsElement(IJavaElement element) {
        return this.fResource.equals((Object)element.getResource());
    }

    @Override
    public boolean exists() {
        if (!this.fResource.exists()) {
            return false;
        }
        IJavaElement javaElement = this.getJavaElement();
        do {
            if (javaElement.exists()) continue;
            return false;
        } while ((javaElement = javaElement.getParent()).getElementType() != 3);
        return true;
    }

    @Override
    public IMarker createMarker(String id) throws CoreException {
        return this.fResource.createMarker(id);
    }
}

