/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otequinox.hook;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.internal.adaptor.EclipseStorageHook;
import org.eclipse.objectteams.otequinox.hook.AspectPermission;
import org.eclipse.objectteams.otequinox.hook.ILogger;
import org.eclipse.objectteams.otequinox.internal.hook.Logger;
import org.eclipse.objectteams.otequinox.internal.hook.OTEquinoxServiceWatcher;
import org.eclipse.objectteams.otequinox.internal.hook.OTStorageHook;
import org.eclipse.objectteams.otequinox.internal.hook.TransformerHook;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingStatsHook;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegateHook;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HookConfigurator
implements org.eclipse.osgi.baseadaptor.HookConfigurator {
    public static final boolean OT_EQUINOX_ENABLED;
    static HookConfigurator instance;
    private Logger logger;

    static {
        String otequinoxProperty = System.getProperty("ot.equinox");
        OT_EQUINOX_ENABLED = otequinoxProperty == null ? false : !"false".equals(otequinoxProperty);
    }

    public HookConfigurator() {
        instance = this;
    }

    public static ILogger getLogger() {
        if (instance == null) {
            throw new RuntimeException("TransformerHook not initialized, perhaps OT/Equinox is not enabled?");
        }
        return HookConfigurator.instance.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHooks(HookRegistry hookRegistry) {
        if (!OT_EQUINOX_ENABLED) {
            return;
        }
        this.logger = new Logger(hookRegistry.getAdaptor().getFrameworkLog());
        TransformerHook transformerHook = new TransformerHook(hookRegistry.getAdaptor());
        hookRegistry.addClassLoadingHook((ClassLoadingHook)transformerHook);
        hookRegistry.addClassLoaderDelegateHook((ClassLoaderDelegateHook)transformerHook);
        hookRegistry.addWatcher((BundleWatcher)transformerHook);
        hookRegistry.addClassLoadingStatsHook((ClassLoadingStatsHook)transformerHook);
        hookRegistry.addAdaptorHook((AdaptorHook)new OTEquinoxServiceWatcher(transformerHook));
        HookRegistry hookRegistry2 = hookRegistry;
        synchronized (hookRegistry2) {
            this.insertStorageHook(hookRegistry, transformerHook);
        }
    }

    private void insertStorageHook(HookRegistry hookRegistry, TransformerHook transformerHook) {
        hookRegistry.addStorageHook(null);
        StorageHook[] allStorageHooks = hookRegistry.getStorageHooks();
        OTStorageHook storageHook = null;
        int i = allStorageHooks.length - 1;
        while (i > 0) {
            allStorageHooks[i] = allStorageHooks[i - 1];
            if (allStorageHooks[i] instanceof EclipseStorageHook) {
                storageHook = new OTStorageHook((EclipseStorageHook)allStorageHooks[i], transformerHook);
            }
            --i;
        }
        if (storageHook != null) {
            allStorageHooks[0] = storageHook;
        } else {
            hookRegistry.getAdaptor().getFrameworkLog().log(new FrameworkLogEntry(HookConfigurator.class.getName(), "EclipseStorageHook not found", 4, null, null));
        }
    }

    public static void parseForcedExportsFile(File configFile, AspectPermission perm) {
        OTStorageHook.parseForcedExportsFile(configFile, perm);
    }

    public static ArrayList<String[]> getForcedExportsByAspect(String aspectBundleId, AspectPermission perm) {
        return OTStorageHook.getForcedExportsByAspect(aspectBundleId, perm);
    }
}

