/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otequinox.internal.hook;

import org.eclipse.objectteams.otequinox.hook.HookConfigurator;
import org.eclipse.objectteams.otequinox.hook.ILogger;
import org.eclipse.objectteams.otequinox.internal.hook.Util;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;

public class Logger
implements ILogger {
    private FrameworkLog fwLog;

    public Logger(FrameworkLog fwLog) {
        this.fwLog = fwLog;
    }

    public void log(Throwable t, String msg) {
        this.log(HookConfigurator.class.getPackage().getName(), t, msg);
    }

    public void log(String pluginID, Throwable t, String msg) {
        if (this.fwLog != null) {
            this.fwLog.log(new FrameworkLogEntry(pluginID, 4, 0, msg, 0, t, null));
            return;
        }
        System.err.println("OT/Equinox: " + msg);
        t.printStackTrace();
    }

    public void log(int status, String msg) {
        if (status >= Util.WARN_LEVEL) {
            this.doLog(HookConfigurator.class.getPackage().getName(), status, msg);
        }
    }

    public void log(String pluginID, int status, String msg) {
        if (status >= Util.WARN_LEVEL) {
            this.doLog(pluginID, status, msg);
        }
    }

    public void doLog(int status, String msg) {
        this.doLog(HookConfigurator.class.getPackage().getName(), status, msg);
    }

    public void doLog(String pluginID, int status, String msg) {
        if (this.fwLog != null) {
            this.fwLog.log(new FrameworkLogEntry(pluginID, status, 0, msg, 0, null, null));
        } else {
            msg = "OT/Equinox: " + msg;
            if ((status & 4) != 0) {
                System.err.println(msg);
            } else {
                System.out.println(msg);
            }
        }
    }
}

