/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.delegate;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.ExpressionInOCL;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.delegate.AbstractDelegatedBehavior;
import org.eclipse.ocl.ecore.delegate.DelegateDomain;
import org.eclipse.ocl.ecore.delegate.DelegateResourceSetAdapter;
import org.eclipse.ocl.ecore.delegate.OCLDelegateDomain;
import org.eclipse.ocl.ecore.delegate.OCLDelegateException;
import org.eclipse.ocl.ecore.delegate.ValidationDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationBehavior
extends AbstractDelegatedBehavior<EClassifier, EValidator.ValidationDelegate.Registry, ValidationDelegate.Factory> {
    public static final ValidationBehavior INSTANCE = new ValidationBehavior();
    public static final String NAME = "validationDelegates";

    @Override
    public ValidationDelegate.Factory getDefaultFactory() {
        return (ValidationDelegate.Factory)ValidationDelegate.Factory.Registry.INSTANCE.getValidationDelegate(this.getName());
    }

    @Override
    public EValidator.ValidationDelegate.Registry getDefaultRegistry() {
        return ValidationDelegate.Factory.Registry.INSTANCE;
    }

    @Override
    public EPackage getEPackage(EClassifier eClassifier) {
        return eClassifier.getEPackage();
    }

    @Override
    public ValidationDelegate.Factory getFactory(DelegateDomain delegateDomain, EClassifier eClassifier) {
        EValidator.ValidationDelegate.Registry registry = DelegateResourceSetAdapter.getRegistry((EModelElement)eClassifier, EValidator.ValidationDelegate.Registry.class, this.getDefaultRegistry());
        return (ValidationDelegate.Factory)registry.getValidationDelegate(delegateDomain.getURI());
    }

    @Override
    public Class<ValidationDelegate.Factory> getFactoryClass() {
        return ValidationDelegate.Factory.class;
    }

    public void cacheOCLExpression(EClassifier cls, String constraintName, OCLExpression e) {
        Object adapter = EcoreUtil.getExistingAdapter((Notifier)cls, InvariantCacheAdapter.class);
        if (adapter == null) {
            if (e == null) {
                return;
            }
            adapter = new InvariantCacheAdapter();
            cls.eAdapters().add(adapter);
        }
        if (e == null) {
            ((InvariantCacheAdapter)((Object)adapter)).remove(constraintName);
        } else {
            ((InvariantCacheAdapter)((Object)adapter)).put(constraintName, e);
        }
    }

    public OCLExpression getCachedOCLExpression(EClassifier cls, String constraintName) {
        Adapter a = EcoreUtil.getExistingAdapter((Notifier)cls, InvariantCacheAdapter.class);
        if (a != null) {
            return ((InvariantCacheAdapter)a).get(constraintName);
        }
        return null;
    }

    public OCLExpression getInvariant(EClassifier cls, String constraintName, OCL ocl) {
        Constraint constraint;
        OCLExpression result = this.getCachedOCLExpression(cls, constraintName);
        if (result != null) {
            return result != NO_OCL_DEFINITION ? result : null;
        }
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext(cls);
        String expr = OCLDelegateDomain.getDelegateAnnotation((EModelElement)cls, constraintName);
        if (expr == null) {
            this.cacheOCLExpression(cls, constraintName, NO_OCL_DEFINITION);
            return null;
        }
        try {
            constraint = (Constraint)helper.createInvariant(expr);
        }
        catch (ParserException e) {
            throw new OCLDelegateException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
        if (constraint == null) {
            return null;
        }
        ExpressionInOCL specification = (ExpressionInOCL)constraint.getSpecification();
        if (specification == null) {
            return null;
        }
        OCLExpression invariant = (OCLExpression)specification.getBodyExpression();
        this.cacheOCLExpression(cls, constraintName, invariant);
        return invariant;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class<ValidationDelegate.Factory.Registry> getRegistryClass() {
        return ValidationDelegate.Factory.Registry.class;
    }

    protected static class InvariantCacheAdapter
    extends AdapterImpl {
        private final Map<String, OCLExpression> invariants = new HashMap<String, OCLExpression>();

        protected InvariantCacheAdapter() {
        }

        public OCLExpression get(String constraintName) {
            return this.invariants.get(constraintName);
        }

        public boolean isAdapterForType(Object type) {
            return type == InvariantCacheAdapter.class;
        }

        public void put(String constraintName, OCLExpression expression) {
            this.invariants.put(constraintName, expression);
        }

        public OCLExpression remove(String constraintName) {
            return this.invariants.remove(constraintName);
        }
    }
}

