/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AbstractNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AlwaysEmptyChangeListener;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.CompositeNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.SourceTypeChangeListener;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.TargetTypeChangeListener;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.TracebackCache;
import org.eclipse.ocl.examples.impactanalyzer.util.AnnotatedEObject;
import org.eclipse.ocl.examples.impactanalyzer.util.SemanticIdentity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchingNavigationStep
extends CompositeNavigationStep {
    private final List<NavigationStep> stepsAlwaysEmptyInThisStepsContext;
    private final SemanticIdentity semanticIdentity = new BranchingNavigationStepIdentity();
    private static final Set<List<NavigationStep>> currentlyReducingForList = new HashSet<List<NavigationStep>>();

    public BranchingNavigationStep(EClass sourceType, EClass targetType, OCLExpression debugInfo, NavigationStep ... parallelSteps) {
        super(sourceType, targetType, debugInfo, parallelSteps);
        this.stepsAlwaysEmptyInThisStepsContext = new ArrayList<NavigationStep>();
        if (this.areAllStepsAlwaysEmpty()) {
            this.setAlwaysEmpty();
        } else {
            NavigationStep[] navigationStepArray = this.getSteps();
            int n = navigationStepArray.length;
            int n2 = 0;
            while (n2 < n) {
                NavigationStep step = navigationStepArray[n2];
                if (!step.isAlwaysEmpty()) {
                    step.addAlwaysEmptyChangeListener(new AlwaysEmptyChangeListener(){

                        public void alwaysEmptyChanged(NavigationStep stepForWhichAlwaysEmptyChanged) {
                            if (BranchingNavigationStep.this.areAllStepsAlwaysEmpty()) {
                                BranchingNavigationStep.this.setAlwaysEmpty();
                            }
                        }
                    });
                    if (step.getSourceType() == null) {
                        step.addSourceTypeChangeListener(new SourceTypeChangeListener(){

                            public void sourceTypeChanged(NavigationStep stepForWhichSourceTypeChanged) {
                                if (!BranchingNavigationStep.haveIntersectingSubclassTree(stepForWhichSourceTypeChanged.getSourceType(), BranchingNavigationStep.this.getSourceType())) {
                                    BranchingNavigationStep.this.stepsAlwaysEmptyInThisStepsContext.add(stepForWhichSourceTypeChanged);
                                    if (BranchingNavigationStep.this.stepsAlwaysEmptyInThisStepsContext.size() == BranchingNavigationStep.this.getSteps().length) {
                                        BranchingNavigationStep.this.setAlwaysEmpty();
                                    }
                                }
                            }
                        });
                    } else if (!BranchingNavigationStep.haveIntersectingSubclassTree(step.getSourceType(), this.getSourceType())) {
                        this.stepsAlwaysEmptyInThisStepsContext.add(step);
                    }
                    if (step.getTargetType() == null) {
                        step.addTargetTypeChangeListener(new TargetTypeChangeListener(){

                            public void targetTypeChanged(NavigationStep stepForWhichTargetTypeChanged) {
                                if (!BranchingNavigationStep.haveIntersectingSubclassTree(stepForWhichTargetTypeChanged.getTargetType(), BranchingNavigationStep.this.getTargetType())) {
                                    BranchingNavigationStep.this.stepsAlwaysEmptyInThisStepsContext.add(stepForWhichTargetTypeChanged);
                                    if (BranchingNavigationStep.this.stepsAlwaysEmptyInThisStepsContext.size() == BranchingNavigationStep.this.getSteps().length) {
                                        BranchingNavigationStep.this.setAlwaysEmpty();
                                    }
                                }
                            }
                        });
                    } else if (!BranchingNavigationStep.haveIntersectingSubclassTree(step.getSourceType(), this.getTargetType())) {
                        this.stepsAlwaysEmptyInThisStepsContext.add(step);
                    }
                }
                ++n2;
            }
        }
    }

    private List<NavigationStep> getFlattenedSubsteps(BranchingNavigationStep branchingNavigationStep) {
        ArrayList<NavigationStep> subStepListHierarchic = new ArrayList<NavigationStep>(branchingNavigationStep.getSteps().length);
        subStepListHierarchic.addAll(Arrays.asList(branchingNavigationStep.getSteps()));
        return this.reduceBranchingNavigationSteps(subStepListHierarchic);
    }

    private List<NavigationStep> reduceBranchingNavigationSteps(List<NavigationStep> stepList) {
        ArrayList<NavigationStep> result = new ArrayList<NavigationStep>();
        result.addAll(stepList);
        if (!currentlyReducingForList.contains(stepList)) {
            currentlyReducingForList.add(stepList);
            for (NavigationStep subStep : stepList) {
                if (!(subStep instanceof BranchingNavigationStep)) continue;
                BranchingNavigationStep subBranchingNavigationStep = (BranchingNavigationStep)subStep;
                if (this.getSourceType() == null || subBranchingNavigationStep.getSourceType() == null || !this.getSourceType().equals(subBranchingNavigationStep.getSourceType()) || this.getTargetType() == null || subBranchingNavigationStep.getTargetType() == null || !this.getTargetType().equals(subBranchingNavigationStep.getTargetType())) continue;
                ArrayList<NavigationStep> subStepListHierarchic = new ArrayList<NavigationStep>(subBranchingNavigationStep.getSteps().length);
                subStepListHierarchic.addAll(Arrays.asList(subBranchingNavigationStep.getSteps()));
                List<NavigationStep> subStepListFlat = this.reduceBranchingNavigationSteps(subStepListHierarchic);
                result.remove(subBranchingNavigationStep);
                result.addAll(subStepListFlat);
            }
            currentlyReducingForList.remove(stepList);
        }
        return result;
    }

    public SemanticIdentity getSemanticIdentityOfSuperSuper() {
        return super.getSemanticIdentityOfAbstractNavigationStep();
    }

    private boolean areAllStepsAlwaysEmpty() {
        boolean result = true;
        int i = 0;
        while (result && i < this.getSteps().length) {
            result = this.getSteps()[i].isAlwaysEmpty();
            ++i;
        }
        return result;
    }

    @Override
    public boolean isAbsolute() {
        return this.isAlwaysEmpty();
    }

    @Override
    protected Set<AnnotatedEObject> navigate(AnnotatedEObject fromObject, TracebackCache cache, Notification changeEvent) {
        HashSet<AnnotatedEObject> result = new HashSet<AnnotatedEObject>();
        NavigationStep[] navigationStepArray = this.getSteps();
        int n = navigationStepArray.length;
        int n2 = 0;
        while (n2 < n) {
            NavigationStep singleStep = navigationStepArray[n2];
            Set<AnnotatedEObject> fromSet = Collections.singleton(fromObject);
            result.addAll(singleStep.navigate(fromSet, cache, changeEvent));
            ++n2;
        }
        return result;
    }

    @Override
    public String contentToString(Map<NavigationStep, Integer> visited, int indent) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append("{\n");
        NavigationStep[] navigationStepArray = this.getSteps();
        int n = navigationStepArray.length;
        int n2 = 0;
        while (n2 < n) {
            NavigationStep step = navigationStepArray[n2];
            this.addIndent(indent + 2, sb);
            if (!first) {
                sb.append("| ");
            } else {
                first = false;
            }
            if (step instanceof AbstractNavigationStep) {
                sb.append(((AbstractNavigationStep)step).toString(visited, indent + 2));
            } else {
                sb.append(step);
            }
            sb.append('\n');
            ++n2;
        }
        this.addIndent(indent, sb);
        sb.append('}');
        return sb.toString();
    }

    private void addIndent(int indent, StringBuilder sb) {
        int i = 0;
        while (i < indent) {
            sb.append(' ');
            ++i;
        }
    }

    @Override
    public SemanticIdentity getSemanticIdentity() {
        return this.semanticIdentity;
    }

    private class BranchingNavigationStepIdentity
    extends SemanticIdentity {
        private BranchingNavigationStepIdentity() {
        }

        public BranchingNavigationStep getNavigationStep() {
            return BranchingNavigationStep.this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.hashCode() != o.hashCode()) {
                return false;
            }
            if (!BranchingNavigationStep.this.getSemanticIdentityOfSuperSuper().equals(o)) {
                return false;
            }
            BranchingNavigationStep other = ((BranchingNavigationStepIdentity)o).getNavigationStep();
            if (other.getSteps().length != this.getNavigationStep().getSteps().length) {
                return false;
            }
            NavigationStep[] navigationStepArray = this.getNavigationStep().getSteps();
            int n = navigationStepArray.length;
            int n2 = 0;
            while (n2 < n) {
                NavigationStep step = navigationStepArray[n2];
                if (!this.otherStepHasEqualStep(step, other.getSteps())) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        private boolean otherStepHasEqualStep(NavigationStep step, NavigationStep ... otherSteps) {
            NavigationStep[] navigationStepArray = otherSteps;
            int n = otherSteps.length;
            int n2 = 0;
            while (n2 < n) {
                NavigationStep stepOfOther = navigationStepArray[n2];
                if (stepOfOther.getSemanticIdentity().equals(step.getSemanticIdentity())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public int calculateHashCode() {
            int hashCode = BranchingNavigationStep.this.getSemanticIdentityOfSuperSuper().hashCode();
            NavigationStep[] navigationStepArray = BranchingNavigationStep.this.getSteps();
            int n = navigationStepArray.length;
            int n2 = 0;
            while (n2 < n) {
                NavigationStep step = navigationStepArray[n2];
                hashCode ^= step.hashCode();
                ++n2;
            }
            return hashCode;
        }

        public NavigationStep getStep() {
            return this.getNavigationStep();
        }
    }
}

