/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback;

import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.ecore.TupleType;
import org.eclipse.ocl.examples.impactanalyzer.impl.OperationBodyToCallMapper;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.AbstractTracebackStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackStepCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequestFactory;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequestSet;
import org.eclipse.ocl.examples.impactanalyzer.util.AnnotatedEObject;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;
import org.eclipse.ocl.examples.impactanalyzer.util.OperationCallExpKeyedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyCallTracebackStep
extends AbstractTracebackStep<PropertyCallExp> {
    private final AbstractTracebackStep.TracebackStepAndScopeChange nextStep;
    private final PropertyCallExp sourceExpression;
    private final EReference oppositeReference;
    private final Strategy strategy;

    public PropertyCallTracebackStep(PropertyCallExp sourceExpression, EClass context, OperationBodyToCallMapper operationBodyToCallMapper, Stack<String> tupleLiteralNamesToLookFor, TracebackStepCache tracebackStepCache, UnusedEvaluationRequestFactory unusedEvaluationRequestFactory, OCLFactory oclFactory) {
        super(sourceExpression, tupleLiteralNamesToLookFor, tracebackStepCache.getOppositeEndFinder(), operationBodyToCallMapper, unusedEvaluationRequestFactory, oclFactory);
        Stack<String> tupleLiteralNames;
        this.sourceExpression = sourceExpression;
        OCLExpression source = (OCLExpression)sourceExpression.getSource();
        if (source.getType() instanceof TupleType) {
            tupleLiteralNames = tupleLiteralNamesToLookFor == null ? new Stack() : this.cloneWithTypeCheck(tupleLiteralNamesToLookFor);
            tupleLiteralNames.push(((EStructuralFeature)sourceExpression.getReferredProperty()).getName());
        } else {
            tupleLiteralNames = tupleLiteralNamesToLookFor;
        }
        this.oppositeReference = sourceExpression.getReferredProperty() instanceof EReference ? ((EReference)sourceExpression.getReferredProperty()).getEOpposite() : null;
        this.nextStep = this.createTracebackStepAndScopeChange((OCLExpression)sourceExpression, source, context, operationBodyToCallMapper, tupleLiteralNames, tracebackStepCache);
        this.strategy = this.determineStrategy();
    }

    private Strategy determineStrategy() {
        Strategy result;
        EStructuralFeature feature = (EStructuralFeature)this.sourceExpression.getReferredProperty();
        if (this.sourceExpression.getSource().getType() instanceof TupleType) {
            result = Strategy.TUPLE;
        } else {
            if (feature instanceof EAttribute) {
                throw new IllegalArgumentException("An EAttribute should never be reached while traceback.");
            }
            if (feature instanceof EReference) {
                EReference ref = (EReference)feature;
                result = ref.getEOpposite() != null ? (ref.getEOpposite().isMany() ? Strategy.OPPOSITE_MANY : Strategy.OPPOSITE_SINGLE) : (ref.isContainment() ? Strategy.CONTAINMENT : Strategy.HIDDEN_OPPOSITE);
            } else {
                throw new RuntimeException("Don't know what type of feature this is: " + feature);
            }
        }
        return result;
    }

    @Override
    protected OperationCallExpKeyedSet performSubsequentTraceback(AnnotatedEObject source, UnusedEvaluationRequestSet pendingUnusedEvalRequests, TracebackCache tracebackCache, Notification changeEvent) {
        OperationCallExpKeyedSet result = tracebackCache.getOperationCallExpKeyedSetFactory().emptySet();
        switch (this.strategy) {
            case TUPLE: {
                result = this.nextStep.traceback(this.annotateEObject(source), pendingUnusedEvalRequests, tracebackCache, changeEvent);
                break;
            }
            case OPPOSITE_MANY: {
                Object o = source.eGet((EStructuralFeature)this.oppositeReference);
                if (!(o instanceof EList)) break;
                EList refObjects = (EList)o;
                HashSet<OperationCallExpKeyedSet> resultSets = new HashSet<OperationCallExpKeyedSet>();
                for (EObject obj : refObjects) {
                    resultSets.add(this.nextStep.traceback(this.annotateEObject(source, obj), pendingUnusedEvalRequests, tracebackCache, changeEvent));
                }
                result = tracebackCache.getOperationCallExpKeyedSetFactory().createOperationCallExpKeyedSet(resultSets);
                break;
            }
            case OPPOSITE_SINGLE: {
                EObject oSingle = (EObject)source.eGet((EStructuralFeature)this.oppositeReference);
                if (oSingle == null) break;
                result = this.nextStep.traceback(this.annotateEObject(source, oSingle), pendingUnusedEvalRequests, tracebackCache, changeEvent);
                break;
            }
            case CONTAINMENT: {
                EObject container = source.eContainer();
                if (container == null) break;
                result = this.nextStep.traceback(this.annotateEObject(source, container), pendingUnusedEvalRequests, tracebackCache, changeEvent);
                break;
            }
            case HIDDEN_OPPOSITE: {
                Collection opposite = this.getOppositeEndFinder().navigateOppositePropertyWithBackwardScope((EReference)this.sourceExpression.getReferredProperty(), source.getAnnotatedObject());
                if (opposite == null || opposite.isEmpty()) break;
                HashSet<OperationCallExpKeyedSet> resultSets = new HashSet<OperationCallExpKeyedSet>();
                for (EObject eo : opposite) {
                    resultSets.add(this.nextStep.traceback(this.annotateEObject(source, eo), pendingUnusedEvalRequests, tracebackCache, changeEvent));
                }
                result = tracebackCache.getOperationCallExpKeyedSetFactory().createOperationCallExpKeyedSet(resultSets);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Strategy {
        TUPLE,
        OPPOSITE_MANY,
        OPPOSITE_SINGLE,
        CONTAINMENT,
        HIDDEN_OPPOSITE;

    }
}

