/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.ocl.examples.library.AbstractIteration;
import org.eclipse.ocl.examples.library.IterationManager;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.pivot.values.CollectionValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnyIteration
extends AbstractIteration<CollectionValue.Accumulator> {
    public static final AnyIteration INSTANCE = new AnyIteration();

    @Override
    public Value evaluate(EvaluationVisitor evaluationVisitor, CollectionValue sourceVal, LoopExp iteratorExp) {
        ValueFactory valueFactory = evaluationVisitor.getValueFactory();
        CollectionValue.Accumulator accumulatorValue = this.createAccumulationValue(valueFactory, true, false);
        return this.evaluateIteration(new IterationManager<CollectionValue.Accumulator>(evaluationVisitor, iteratorExp, sourceVal, accumulatorValue));
    }

    @Override
    protected Value resolveTerminalValue(IterationManager<CollectionValue.Accumulator> iterationManager) {
        CollectionValue.Accumulator accumulatorValue = iterationManager.getAccumulatorValue();
        if (accumulatorValue.intSize() > 0) {
            return (Value)accumulatorValue.asList().get(0);
        }
        return iterationManager.getValueFactory().getNull();
    }

    @Override
    protected Value updateAccumulator(IterationManager<CollectionValue.Accumulator> iterationManager) {
        CollectionValue.Accumulator accumulatorValue = iterationManager.getAccumulatorValue();
        Value bodyVal = iterationManager.getBodyValue();
        if (bodyVal.isUndefined()) {
            return iterationManager.throwInvalidEvaluation(EvaluatorMessages.UndefinedBody, "any");
        }
        if (bodyVal.isFalse()) {
            return null;
        }
        if (accumulatorValue.intSize() > 0) {
            return iterationManager.getFalse();
        }
        Value value = iterationManager.get(0);
        accumulatorValue.add(value);
        return null;
    }
}

