/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import java.util.HashMap;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.ocl.examples.library.AbstractIteration;
import org.eclipse.ocl.examples.library.IterationManager;
import org.eclipse.ocl.examples.library.ValidationWarning;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.CollectionValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureIteration
extends AbstractIteration<CollectionValue.Accumulator> {
    public static final ClosureIteration INSTANCE = new ClosureIteration();

    @Override
    public Value evaluate(EvaluationVisitor evaluationVisitor, CollectionValue sourceVal, LoopExp iteratorExp) {
        ValueFactory valueFactory = evaluationVisitor.getValueFactory();
        TypeManager typeManager = evaluationVisitor.getTypeManager();
        Type sourceType = iteratorExp.getSource().getType();
        boolean isOrdered = typeManager.isOrdered(sourceType);
        CollectionValue.Accumulator accumulatorValue = this.createAccumulationValue(valueFactory, isOrdered, true);
        return this.evaluateIteration(new IterationManager<CollectionValue.Accumulator>(evaluationVisitor, iteratorExp, sourceVal, accumulatorValue));
    }

    @Override
    protected Value updateAccumulator(IterationManager<CollectionValue.Accumulator> iterationManager) {
        Value value;
        CollectionValue.Accumulator accumulatorValue = iterationManager.getAccumulatorValue();
        if (!iterationManager.isOuterIteration() && !accumulatorValue.add(value = iterationManager.get(0))) {
            return accumulatorValue;
        }
        Value bodyVal = iterationManager.getBodyValue();
        if (bodyVal.isInvalid()) {
            return bodyVal;
        }
        if (bodyVal.isUndefined()) {
            return accumulatorValue;
        }
        try {
            this.evaluateIteration(new IterationManager<CollectionValue.Accumulator>(iterationManager, bodyVal));
        }
        catch (InvalidValueException e) {
            iterationManager.throwInvalidEvaluation(e);
        }
        return null;
    }

    @Override
    public Diagnostic validate(TypeManager typeManager, CallExp callExp) {
        HashMap bindings;
        Type iteratorType;
        Type bodyType = ((IteratorExp)callExp).getBody().getType();
        if (bodyType instanceof CollectionType) {
            bodyType = ((CollectionType)bodyType).getElementType();
        }
        if (!typeManager.conformsTo(bodyType, iteratorType = ((Variable)((IteratorExp)callExp).getIterators().get(0)).getType(), bindings = new HashMap())) {
            return new ValidationWarning(OCLMessages.IncompatibleBodyType_WARNING_, bodyType, iteratorType);
        }
        return null;
    }
}

