/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.ocl.examples.library.AbstractIteration;
import org.eclipse.ocl.examples.library.IterationManager;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.pivot.values.CollectionValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExistsIteration
extends AbstractIteration<CollectionValue.Accumulator> {
    public static final ExistsIteration INSTANCE = new ExistsIteration();

    @Override
    public Value evaluate(EvaluationVisitor evaluationVisitor, CollectionValue sourceVal, LoopExp iteratorExp) {
        ValueFactory valueFactory = evaluationVisitor.getValueFactory();
        CollectionValue.Accumulator accumulatorValue = this.createAccumulationValue(valueFactory, true, false);
        return this.evaluateIteration(new IterationManager<CollectionValue.Accumulator>(evaluationVisitor, iteratorExp, sourceVal, accumulatorValue));
    }

    @Override
    protected Value resolveTerminalValue(IterationManager<CollectionValue.Accumulator> iterationManager) {
        return iterationManager.getFalse();
    }

    @Override
    protected Value updateAccumulator(IterationManager<CollectionValue.Accumulator> iterationManager) {
        Value bodyVal = iterationManager.getBodyValue();
        if (bodyVal.isUndefined()) {
            return iterationManager.throwInvalidEvaluation(EvaluatorMessages.UndefinedBody, "exists");
        }
        if (bodyVal.isFalse()) {
            return null;
        }
        return iterationManager.getTrue();
    }
}

