/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.ocl.examples.library.AbstractIteration;
import org.eclipse.ocl.examples.library.IterationManager;
import org.eclipse.ocl.examples.library.ValidationWarning;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.evaluation.CallableImplementation;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.BooleanValue;
import org.eclipse.ocl.examples.pivot.values.CollectionValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.impl.AbstractValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedByIteration
extends AbstractIteration<SortingValue> {
    public static final SortedByIteration INSTANCE = new SortedByIteration();

    @Override
    public Value evaluate(EvaluationVisitor evaluationVisitor, CollectionValue sourceVal, LoopExp iteratorExp) {
        EvaluationEnvironment evaluationEnvironment = evaluationVisitor.getEvaluationEnvironment();
        TypeManager typeManager = evaluationEnvironment.getTypeManager();
        OclExpression body = iteratorExp.getBody();
        Type staticValueType = PivotUtil.getBehavioralType((Type)body.getType());
        Operation staticLessThanOperation = typeManager.resolveOperation(staticValueType, "<", new Type[]{staticValueType});
        if (staticLessThanOperation == null) {
            return evaluationEnvironment.throwInvalidEvaluation(null, (OclExpression)iteratorExp, (Object)sourceVal, EvaluatorMessages.UndefinedOperation, new Object[]{"<"});
        }
        CallableImplementation implementation = null;
        try {
            implementation = typeManager.getImplementation(staticLessThanOperation);
        }
        catch (Exception e) {
            evaluationEnvironment.throwInvalidEvaluation((Throwable)e, (OclExpression)iteratorExp, (Object)sourceVal, EvaluatorMessages.ImplementationClassLoadFailure, new Object[]{staticLessThanOperation.getImplementationClass()});
        }
        if (implementation == null) {
            evaluationEnvironment.throwInvalidEvaluation(null, (OclExpression)iteratorExp, (Object)sourceVal, EvaluatorMessages.ImplementationClassLoadFailure, new Object[]{staticLessThanOperation.getImplementationClass()});
        }
        if (!(implementation instanceof Value.BinaryOperation)) {
            evaluationEnvironment.throwInvalidEvaluation(null, (OclExpression)iteratorExp, (Object)sourceVal, EvaluatorMessages.NonBinaryOperation, new Object[]{staticValueType, "<"});
        }
        Value.BinaryOperation binaryImplementation = (Value.BinaryOperation)implementation;
        SortingValue accumulatorValue = new SortingValue(evaluationEnvironment, (Value)sourceVal, iteratorExp, binaryImplementation);
        return this.evaluateIteration(new IterationManager<SortingValue>(evaluationVisitor, iteratorExp, sourceVal, accumulatorValue));
    }

    @Override
    protected Value resolveTerminalValue(IterationManager<SortingValue> iterationManager) {
        SortingValue accumulatorValue = iterationManager.getAccumulatorValue();
        return accumulatorValue.createSortedValue();
    }

    @Override
    protected Value updateAccumulator(IterationManager<SortingValue> iterationManager) {
        SortingValue accumulatorValue = iterationManager.getAccumulatorValue();
        Value bodyVal = iterationManager.getBodyValue();
        if (bodyVal.isUndefined()) {
            return iterationManager.throwInvalidEvaluation(EvaluatorMessages.UndefinedBody, "sortedBy");
        }
        Value iterValue = iterationManager.get(0);
        accumulatorValue.put(iterValue, bodyVal);
        return null;
    }

    @Override
    public Diagnostic validate(TypeManager typeManager, CallExp callExp) {
        Type type = ((LoopExp)callExp).getBody().getType();
        TemplateParameter templateParameter = type.getOwningTemplateParameter();
        if (templateParameter != null) {
            Map templateParameterSubstitutions = PivotUtil.getAllTemplateParameterSubstitutions(null, (TemplateableElement)callExp.getSource().getType());
            type = (Type)templateParameterSubstitutions.get(templateParameter);
        }
        type = PivotUtil.getBehavioralType((Type)type);
        Operation operation = typeManager.resolveOperation(type, "<", new Type[]{type});
        if (operation == null) {
            return new ValidationWarning(OCLMessages.UnresolvedOperation_ERROR_, "<", String.valueOf(type));
        }
        try {
            CallableImplementation implementation = typeManager.getImplementation(operation);
            if (implementation == null) {
                return new ValidationWarning(EvaluatorMessages.ImplementationClassLoadFailure, operation.getImplementationClass());
            }
            if (!(implementation instanceof Value.BinaryOperation)) {
                return new ValidationWarning(EvaluatorMessages.NonBinaryOperation, type, "<");
            }
            return null;
        }
        catch (Exception e) {
            return new ValidationWarning(EvaluatorMessages.ImplementationClassLoadFailure, operation.getImplementationClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SortingValue
    extends AbstractValue
    implements Comparator<Value> {
        private final EvaluationEnvironment evaluationEnvironment;
        private final Map<Value, Value> content = new HashMap<Value, Value>();
        private final LoopExp iteratorExp;
        private final Value.BinaryOperation binaryImplementation;

        public SortingValue(EvaluationEnvironment env, Value sourceVal, LoopExp iteratorExp, Value.BinaryOperation binaryImplementation) {
            super(env.getValueFactory());
            this.evaluationEnvironment = env;
            this.iteratorExp = iteratorExp;
            this.binaryImplementation = binaryImplementation;
        }

        public Object asObject() {
            return this.content;
        }

        public Value asValidValue() {
            return this;
        }

        @Override
        public int compare(Value o1, Value o2) {
            Value v2;
            Value v1;
            block6: {
                if (o1 == o2) {
                    return 0;
                }
                v1 = this.content.get(o1);
                if (v1 == (v2 = this.content.get(o2))) {
                    return 0;
                }
                try {
                    BooleanValue lessThan = this.binaryImplementation.evaluate(this.valueFactory, v1, v2).asBooleanValue();
                    if (!lessThan.isTrue()) break block6;
                    return -1;
                }
                catch (InvalidValueException e) {
                    this.evaluationEnvironment.throwInvalidEvaluation(e);
                    return 0;
                }
            }
            BooleanValue greaterThan = this.binaryImplementation.evaluate(this.valueFactory, v2, v1).asBooleanValue();
            if (greaterThan.isTrue()) {
                return 1;
            }
            return 0;
        }

        public Value createSortedValue() {
            ArrayList<Value> result = new ArrayList<Value>(this.content.keySet());
            Collections.sort(result, this);
            Type sourceType = this.iteratorExp.getSource().getType();
            boolean isUnique = this.evaluationEnvironment.getTypeManager().isUnique(sourceType);
            return this.valueFactory.createCollectionValue(true, isUnique, result);
        }

        public Type getType(TypeManager typeManager, Type staticType) {
            return staticType;
        }

        public void put(Value iterVal, Value comparable) {
            this.content.put(iterVal, comparable);
        }

        public String toString() {
            return this.content.toString();
        }
    }
}

