/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.numeric;

import org.eclipse.ocl.examples.library.AbstractBinaryOperation;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.values.IntegerValue;
import org.eclipse.ocl.examples.pivot.values.RealValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNumericBinaryOperation
extends AbstractBinaryOperation {
    @Override
    public Value evaluate(ValueFactory valueFactory, Value left, Value right) throws InvalidValueException {
        if (left.isUnlimited() || right.isUnlimited()) {
            return this.evaluateUnlimited(valueFactory, left, right);
        }
        IntegerValue leftInteger = left.isIntegerValue();
        IntegerValue rightInteger = right.isIntegerValue();
        if (leftInteger != null && rightInteger != null) {
            return this.evaluateInteger(valueFactory, leftInteger, rightInteger);
        }
        RealValue leftReal = left.toRealValue();
        RealValue rightReal = right.toRealValue();
        return this.evaluateReal(valueFactory, leftReal, rightReal);
    }

    protected Value evaluateInteger(ValueFactory valueFactory, IntegerValue left, IntegerValue right) throws InvalidValueException {
        return this.evaluate(valueFactory, (Value)left, (Value)right);
    }

    protected Value evaluateReal(ValueFactory valueFactory, RealValue left, RealValue right) throws InvalidValueException {
        return this.evaluate(valueFactory, (Value)left, (Value)right);
    }

    protected Value evaluateUnlimited(ValueFactory valueFactory, Value left, Value right) throws InvalidValueException {
        return null;
    }

    protected <T extends Number> Object evaluate(ValueFactory valueFactory, T left, T right) throws InvalidValueException {
        return null;
    }
}

