/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.modelregistry.ui.properties;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ocl.examples.modelregistry.eclipse.EclipseProjectHandle;
import org.eclipse.ocl.examples.modelregistry.environment.FileHandle;
import org.eclipse.ocl.examples.modelregistry.environment.ModelRegistryEnvironment;
import org.eclipse.ocl.examples.modelregistry.environment.ProjectHandle;
import org.eclipse.ocl.examples.modelregistry.model.Accessor;
import org.eclipse.ocl.examples.modelregistry.model.ModelNameAccessor;
import org.eclipse.ocl.examples.modelregistry.model.NamespaceRegistry;
import org.eclipse.ocl.examples.modelregistry.ui.help.ModelRegistryHelpIds;
import org.eclipse.ocl.examples.modelregistry.ui.help.ModelRegistryHelper;
import org.eclipse.ocl.examples.modelregistry.ui.properties.ConfigurationBlock;
import org.eclipse.ocl.examples.modelregistry.ui.properties.PreferencesMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;

public class PropertyPage
extends PreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage,
ModelRegistryHelpIds {
    public static final String PREF_ID = "org.eclipse.ocl.examples.modelregistry.ui.preferences.ModelRegistryPreferencePage";
    public static final String PROP_ID = "org.eclipse.ocl.examples.modelregistry.ui.propertyPages.ModelRegistryPreferencePage";
    private FileHandle fileHandle;
    private Combo accessorCombo = null;
    private Control fConfigurationBlockControl;
    private ConfigurationBlock configurationBlock;

    public PropertyPage() {
        this.setTitle(PreferencesMessages.ModelRegistryPreferencePage_title);
    }

    protected void contributeButtons(Composite parent) {
        this.createAccessorCombo(parent);
        this.createFiller(parent);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        this.configurationBlock.createAddButton(parent, widthHint);
        this.configurationBlock.createEditButton(parent, widthHint);
        this.configurationBlock.createRemoveButton(parent, widthHint);
        this.createFiller(parent);
        parent.setLayoutData((Object)new GridData(256));
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).numColumns += 7;
        }
        super.contributeButtons(parent);
    }

    private Combo createAccessorCombo(Composite inner) {
        NamespaceRegistry namespaceRegistry = ModelRegistryEnvironment.getInstance().getNamespaceRegistry();
        ArrayList kindList = new ArrayList(namespaceRegistry.getNamespaces());
        int iMax = kindList.size();
        Object[] kindArray = new String[iMax];
        int i = 0;
        while (i < iMax) {
            kindArray[i] = ((Accessor.Namespace)kindList.get(i)).getName();
            ++i;
        }
        Arrays.sort(kindArray);
        Label namespaceLabel = new Label(inner, 0);
        namespaceLabel.setText(PreferencesMessages.ModelRegistryConfigurationBlock_accessor_label);
        this.accessorCombo = new Combo(inner, 0);
        this.accessorCombo.setItems((String[])kindArray);
        this.accessorCombo.select(this.accessorCombo.indexOf(ModelNameAccessor.NAMESPACE.getName()));
        this.accessorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!PropertyPage.this.configurationBlock.setNamespaceName(PropertyPage.this.accessorCombo.getText())) {
                    PropertyPage.this.accessorCombo.select(PropertyPage.this.accessorCombo.indexOf(PropertyPage.this.configurationBlock.getNamespaceName()));
                }
            }
        });
        ModelRegistryHelper.setHelp((Control)namespaceLabel, ModelRegistryHelpIds.General.ACCESSOR_KIND);
        ModelRegistryHelper.setHelp((Control)this.accessorCombo, ModelRegistryHelpIds.General.ACCESSOR_KIND);
        return this.accessorCombo;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        this.fConfigurationBlockControl = this.createPreferenceContent(composite);
        this.fConfigurationBlockControl.setLayoutData((Object)new GridData(4, 4, true, true));
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void createControl(Composite parent) {
        this.configurationBlock = new ConfigurationBlock(this.getFileHandle());
        super.createControl(parent);
        ModelRegistryHelper.setHelp(this.getControl(), ModelRegistryHelpIds.PropertyPage.OVERVIEW);
        this.getDefaultsButton().setText(JFaceResources.getString((String)"Revert"));
    }

    protected Label createDescriptionLabel(Composite parent) {
        if (this.isProjectPreferencePage()) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Label horizontalLine = new Label(composite, 258);
            horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            horizontalLine.setFont(composite.getFont());
        }
        return super.createDescriptionLabel(parent);
    }

    private void createFiller(Composite parent) {
        Label filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    protected Control createPreferenceContent(Composite composite) {
        return this.configurationBlock.createContents(composite);
    }

    public void dispose() {
        if (this.configurationBlock != null) {
            this.configurationBlock.dispose();
        }
        super.dispose();
    }

    protected void doStatusChanged() {
    }

    public IAdaptable getElement() {
        return this.fileHandle;
    }

    protected String getPreferencePageID() {
        return PREF_ID;
    }

    protected ProjectHandle getProjectHandle() {
        return this.fileHandle.getProjectHandle();
    }

    protected String getPropertyPageID() {
        return PROP_ID;
    }

    protected FileHandle getFileHandle() {
        return this.fileHandle;
    }

    public void init(IWorkbench workbench) {
    }

    protected boolean isProjectPreferencePage() {
        return this.fileHandle != null;
    }

    public void performApply() {
        if (this.configurationBlock != null) {
            this.configurationBlock.performApply();
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.configurationBlock != null) {
            this.configurationBlock.performDefaults();
        }
    }

    public boolean performOk() {
        if (this.configurationBlock != null && !this.configurationBlock.performOk()) {
            return false;
        }
        return super.performOk();
    }

    public void setElement(IAdaptable element) {
        IResource resource = (IResource)element.getAdapter(IResource.class);
        if (resource != null) {
            EclipseProjectHandle projectHandle = new EclipseProjectHandle(resource.getProject());
            this.fileHandle = projectHandle.getFileHandle(resource);
        } else {
            this.fileHandle = null;
        }
        this.setDescription(null);
    }

    public void setVisible(boolean visible) {
        if (this.getControl() != null) {
            super.setVisible(visible);
        }
    }

    protected boolean supportsProjectSpecificOptions() {
        return this.getPropertyPageID() != null;
    }
}

