/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.modelregistry.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ocl.examples.modelregistry.environment.FileHandle;
import org.eclipse.ocl.examples.modelregistry.environment.ModelRegistryEnvironment;
import org.eclipse.ocl.examples.modelregistry.model.Accessor;
import org.eclipse.ocl.examples.modelregistry.model.FileHandleRegistry;
import org.eclipse.ocl.examples.modelregistry.model.ModelSerialization;
import org.eclipse.ocl.examples.modelregistry.model.NamespaceRegistry;
import org.eclipse.ocl.examples.modelregistry.model.ProjectRegistry;
import org.eclipse.ocl.examples.modelregistry.model.Registration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessorRegistry<A extends Accessor<A>>
implements Comparable<AccessorRegistry<A>> {
    private final FileHandleRegistry parent;
    private final Accessor.Namespace<A> namespace;
    private final Map<String, Registration<A>> registrations = new HashMap<String, Registration<A>>();

    public AccessorRegistry(FileHandleRegistry parent, Accessor.Namespace<A> namespace) {
        this.parent = parent;
        this.namespace = namespace;
    }

    public Registration<A> add(String accessorName, URI uri, ModelSerialization modelSerialisation) {
        NamespaceRegistry namespaceRegistry = ModelRegistryEnvironment.getInstance().getNamespaceRegistry();
        A accessor = namespaceRegistry.createAccessor(this.namespace, accessorName);
        return this.add(accessor, uri, modelSerialisation);
    }

    public Registration<A> add(A accessor, URI uri, ModelSerialization modelSerialisation) {
        Registration<A> registration = new Registration<A>(this, accessor, uri, modelSerialisation);
        this.registrations.put(accessor.getName(), registration);
        return registration;
    }

    public Registration<A> add(Registration<A> registration) {
        return this.registrations.put(registration.getAccessorName(), registration);
    }

    public void clear() {
        this.registrations.clear();
    }

    @Override
    public int compareTo(AccessorRegistry<A> accessorRegistry) {
        return this.getNamespace().getName().compareTo(accessorRegistry.getNamespace().getName());
    }

    public Registration<A> createRegistration(String accessorName, String resourceURI, ModelSerialization modelSerialisation) {
        NamespaceRegistry namespaceRegistry = ModelRegistryEnvironment.getInstance().getNamespaceRegistry();
        A accessor = namespaceRegistry.createAccessor(this.getNamespace(), accessorName);
        URI uri = URI.createURI((String)resourceURI);
        return new Registration<A>(this, accessor, uri, modelSerialisation);
    }

    public Registration<A> get(A accessor) {
        return this.registrations.get(accessor.getName());
    }

    public FileHandle getFileHandle() {
        return this.parent.getFileHandle();
    }

    public FileHandleRegistry getFileHandleRegistry() {
        return this.parent;
    }

    public Accessor.Namespace<A> getNamespace() {
        return this.namespace;
    }

    public ProjectRegistry getProjectRegistry() {
        return this.parent.getProjectRegistry();
    }

    public Collection<String> getRegistrationKeys() {
        return this.registrations.keySet();
    }

    public Collection<Registration<A>> getRegistrations() {
        return this.registrations.values();
    }

    public Registration<A> remove(Registration<A> registration) {
        return this.registrations.remove(registration.getAccessorName());
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.parent)) + "[" + this.namespace.getName() + "]";
    }
}

