/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.parser.environment;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.examples.modelregistry.environment.AbstractModelResolver;
import org.eclipse.ocl.examples.parser.environment.CSTNodeEnvironment;
import org.eclipse.ocl.examples.parser.environment.ICSTFileEnvironment;
import org.eclipse.ocl.examples.parser.environment.ICSTNodeEnvironment;
import org.eclipse.ocl.examples.parser.environment.ICSTRootEnvironment;
import org.eclipse.ocl.examples.parser.environment.UnresolvedEnvironment;
import org.eclipse.ocl.examples.parser.utils.CSTFormattingHelper;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CSTChildEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E, V extends ICSTNodeEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>, PV extends ICSTNodeEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>, AST extends Notifier, CST extends CSTNode>
extends CSTNodeEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E, V, AST, CST> {
    protected final ICSTRootEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> rootEnvironment;
    protected int errorStart = 0;
    protected int errorEnd = 0;

    protected CSTChildEnvironment(PV parent, AST astNode, CST cstNode) {
        super(parent, astNode, cstNode);
        this.rootEnvironment = parent.getRootEnvironment();
        assert (this.rootEnvironment != null);
        this.initASTMapping(astNode, (CSTNode)cstNode);
    }

    @Override
    public boolean checkFeatureCompatibility(CSTNode cstNode, C featureType, OCLExpression<C> oclExpression) {
        return this.rootEnvironment.checkFeatureCompatibility(cstNode, featureType, oclExpression);
    }

    @Override
    public InvalidLiteralExp<C> createInvalidLiteralExp(CSTNode cstNode) {
        return this.rootEnvironment.createInvalidLiteralExp(cstNode);
    }

    public P defineAttribute(C owner, Variable<C, PM> variable, CT constraint) {
        return (P)this.rootEnvironment.defineAttribute(owner, variable, constraint);
    }

    public O defineOperation(C owner, String name, C type, List<Variable<C, PM>> params, CT constraint) {
        return (O)this.rootEnvironment.defineOperation(owner, name, type, params, constraint);
    }

    public CSTNode getASTMapping(Object object) {
        return this.rootEnvironment.getASTMapping(object);
    }

    @Override
    public Map<Object, CSTNode> getASTNodeToCSTNodeMap() {
        return this.rootEnvironment.getASTNodeToCSTNodeMap();
    }

    public CT getDefinition(Object feature) {
        return (CT)this.rootEnvironment.getDefinition(feature);
    }

    public EnvironmentFactory<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getFactory() {
        return this.rootEnvironment.getFactory();
    }

    @Override
    public ICSTFileEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getFileEnvironment() {
        return this.rootEnvironment.getFileEnvironment();
    }

    @Override
    public CSTFormattingHelper getFormatter() {
        return this.rootEnvironment.getFormatter();
    }

    public OCLFactory getOCLFactory() {
        return this.rootEnvironment.getOCLFactory();
    }

    public OCLStandardLibrary<C> getOCLStandardLibrary() {
        return this.rootEnvironment.getOCLStandardLibrary();
    }

    public PV getParentEnvironment() {
        return (PV)((ICSTNodeEnvironment)this.getInternalParent());
    }

    public AbstractParser getParser() {
        return this.rootEnvironment.getParser();
    }

    public ProblemHandler getProblemHandler() {
        return this.rootEnvironment.getProblemHandler();
    }

    @Override
    public AbstractModelResolver getResolver() {
        return this.rootEnvironment.getResolver();
    }

    @Override
    public ICSTRootEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getRootEnvironment() {
        return this.rootEnvironment;
    }

    public List<S> getStates(C owner, List<String> pathPrefix) {
        return this.rootEnvironment.getStates(owner, pathPrefix);
    }

    public TypeResolver<C, O, P> getTypeResolver() {
        return this.rootEnvironment.getTypeResolver();
    }

    public UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> getUMLReflection() {
        return this.rootEnvironment.getUMLReflection();
    }

    @Override
    public UnresolvedEnvironment getUnresolvedEnvironment() {
        return this.rootEnvironment.getUnresolvedEnvironment();
    }

    public void initASTMapping(Object astNode, CSTNode cstNode) {
        this.rootEnvironment.initASTMapping(astNode, cstNode);
    }

    public void initASTMapping(Object fromAstNode, CSTNode cstNode, Object toAstNode) {
        this.rootEnvironment.initASTMapping(fromAstNode, cstNode, toAstNode);
    }

    public boolean isInPostcondition(OCLExpression<C> exp) {
        return this.rootEnvironment.isInPostcondition(exp);
    }

    @Override
    public boolean isResolved(EObject eObject) {
        return this.rootEnvironment.isResolved(eObject);
    }

    public PK lookupPackage(List<String> names) {
        return (PK)this.rootEnvironment.lookupPackage(names);
    }

    public void setParent(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        this.rootEnvironment.setParent(env);
    }

    public C tryLookupAssociationClassReference(C owner, String name) throws LookupException {
        Object result = super.lookupAssociationClassReference(owner, name);
        if (result != null) {
            return (C)result;
        }
        PV parent = this.getParentEnvironment();
        if (parent != null) {
            return (C)parent.tryLookupAssociationClassReference(owner, name);
        }
        return null;
    }

    public C tryLookupClassifier(List<String> names) throws LookupException {
        Object result = this.lookupClassifier(names);
        if (result != null) {
            return result;
        }
        PV parent = this.getParentEnvironment();
        if (parent != null) {
            return (C)parent.tryLookupClassifier(names);
        }
        return null;
    }

    public O tryLookupOperation(C owner, String name, List<? extends TypedElement<C>> args) throws LookupException {
        Object result = super.lookupOperation(owner, name, args);
        if (result != null) {
            return (O)result;
        }
        PV parent = this.getParentEnvironment();
        if (parent != null) {
            return (O)parent.tryLookupOperation(owner, name, args);
        }
        return null;
    }

    public PK tryLookupPackage(List<String> names) throws LookupException {
        PK result = this.lookupPackage(names);
        if (result != null) {
            return result;
        }
        PV parent = this.getParentEnvironment();
        if (parent != null) {
            return (PK)parent.tryLookupPackage(names);
        }
        return null;
    }

    public P tryLookupProperty(C owner, String name) throws LookupException {
        if (name == null) {
            return null;
        }
        Object result = super.lookupProperty(owner, name);
        if (result != null) {
            return (P)result;
        }
        PV parent = this.getParentEnvironment();
        if (parent != null) {
            return (P)parent.tryLookupProperty(owner, name);
        }
        return null;
    }

    public C tryLookupSignal(C owner, String name, List<? extends TypedElement<C>> args) throws LookupException {
        Object result = super.lookupSignal(owner, name, args);
        if (result != null) {
            return (C)result;
        }
        PV parent = this.getParentEnvironment();
        if (parent != null) {
            return (C)parent.tryLookupSignal(owner, name, args);
        }
        return null;
    }

    public void undefine(Object feature) {
        this.rootEnvironment.undefine(feature);
    }

    public void validateASTMappings(List<EPackage> ePackages) {
        for (EPackage ePackage : ePackages) {
            TreeIterator i = ePackage.eAllContents();
            while (i.hasNext()) {
                EObject eObject = (EObject)i.next();
                if (this.getASTMapping(eObject) != null || eObject instanceof EGenericType || eObject instanceof CollectionType || eObject instanceof TypeType || eObject instanceof InvalidLiteralExp) continue;
                System.out.println(String.valueOf(this.formatName(eObject.eClass())) + " : " + this.formatQualifiedName(eObject) + " has no mapping to a CST node");
            }
        }
    }
}

