/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.parser.environment;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreValidator;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.IsMarkedPreCS;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.TypeType;
import org.eclipse.ocl.examples.common.utils.EcoreUtils;
import org.eclipse.ocl.examples.common.utils.XMIUtils;
import org.eclipse.ocl.examples.modelregistry.environment.AbstractModelResolver;
import org.eclipse.ocl.examples.parser.environment.CSTNodeEnvironment;
import org.eclipse.ocl.examples.parser.environment.CSTRootEnvironment;
import org.eclipse.ocl.examples.parser.environment.ICSTEnvironment;
import org.eclipse.ocl.examples.parser.environment.ICSTFileEnvironment;
import org.eclipse.ocl.examples.parser.environment.ICSTNodeEnvironment;
import org.eclipse.ocl.examples.parser.environment.ICSTRootEnvironment;
import org.eclipse.ocl.examples.parser.environment.ProblemHandlerDiagnosticChain;
import org.eclipse.ocl.examples.parser.environment.UnresolvedEnvironment;
import org.eclipse.ocl.examples.parser.utils.ErrorNode;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CSTRootEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E, V extends ICSTNodeEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>, CST extends CSTNode>
extends CSTNodeEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E, V, XMIResource, CST>
implements ICSTRootEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    protected final ICSTFileEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> fileEnvironment;
    private UnresolvedEnvironment unresolvedEnvironment = null;

    protected CSTRootEnvironment(ICSTFileEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> fileEnvironment, XMIResource astNode, CST cstNode) {
        super(fileEnvironment, astNode, cstNode);
        assert (astNode != null);
        this.fileEnvironment = fileEnvironment;
        this.initASTMapping(astNode, (CSTNode)cstNode);
    }

    public UnresolvedEnvironment basicGetUnresolvedEnvironment() {
        return this.unresolvedEnvironment;
    }

    @Override
    public void checkMappings() {
        CSTNode eObject;
        boolean hasErrorNode;
        EPackage rootUnresolvedEPackage = this.unresolvedEnvironment != null ? this.unresolvedEnvironment.getUnresolvedEPackage() : null;
        TreeIterator i = ((XMIResource)this.ast).getAllContents();
        while (i.hasNext()) {
            EObject astNode = (EObject)i.next();
            CSTNode cstNode = this.getASTMapping(astNode);
            if (cstNode != null || astNode instanceof EGenericType || astNode instanceof EPackage && ((EPackage)astNode).getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL") != null || astNode instanceof EClassifier && ((EClassifier)astNode).getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL") != null || astNode instanceof EAttribute && ((EAttribute)astNode).getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL") != null || astNode instanceof EOperation && ((EOperation)astNode).getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL") != null || astNode instanceof EParameter && ((EParameter)astNode).getEOperation().getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL") != null || astNode instanceof EAnnotation && "http://www.eclipse.org/ocl/1.1.0/OCL".equals(((EAnnotation)astNode).getSource()) || astNode instanceof CollectionType && ((CollectionType)astNode).getEPackage().getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL") != null) continue;
            hasErrorNode = false;
            if (rootUnresolvedEPackage != null) {
                eObject = astNode;
                while (eObject != null) {
                    if (eObject == rootUnresolvedEPackage) {
                        hasErrorNode = true;
                        break;
                    }
                    eObject = eObject.eContainer();
                }
            }
            if (hasErrorNode) continue;
            System.out.println("No AST to CST mapping for " + EcoreUtils.qualifiedNameFor((Object)astNode));
        }
        i = this.cst.eAllContents();
        while (i.hasNext()) {
            CSTNode cstNode = (CSTNode)i.next();
            Object astNode = cstNode.getAst();
            if (astNode != null || cstNode instanceof IsMarkedPreCS) continue;
            hasErrorNode = false;
            eObject = cstNode;
            while (eObject instanceof CSTNode) {
                Object ast = eObject.getAst();
                if (ast instanceof ErrorNode || ast instanceof InvalidLiteralExp) {
                    hasErrorNode = true;
                    break;
                }
                eObject = eObject.eContainer();
            }
            if (hasErrorNode) continue;
            System.out.println("No CST to AST mapping for " + EcoreUtils.qualifiedNameFor((Object)cstNode) + " in " + String.valueOf(((XMIResource)this.ast).getURI()));
        }
    }

    protected ProblemHandlerDiagnosticChain createDiagnosticChain() {
        return new ProblemHandlerDiagnosticChain((BasicEnvironment)this);
    }

    protected Diagnostician createDiagnostician() {
        return new WorkaroundDiagnostician();
    }

    protected EValidator.SubstitutionLabelProvider createSubstitutionLabelProvider(Diagnostician diagnostician) {
        return this.getFormatter();
    }

    protected UnresolvedEnvironment createUnresolvedEnvironment() {
        return new UnresolvedEnvironment(this);
    }

    @Override
    public int getCSTErrorTokens() {
        return this.getParser().getIPrsStream().getErrorTokens();
    }

    @Override
    public ICSTFileEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getFileEnvironment() {
        return this.fileEnvironment;
    }

    public AbstractParser getParser() {
        return this.fileEnvironment.getParser();
    }

    @Override
    public AbstractModelResolver getResolver() {
        return this.fileEnvironment.getResolver();
    }

    @Override
    public ICSTRootEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getRootEnvironment() {
        return this;
    }

    public UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> getUMLReflection() {
        return this.fileEnvironment.getUMLReflection();
    }

    @Override
    public UnresolvedEnvironment getUnresolvedEnvironment() {
        if (this.unresolvedEnvironment == null) {
            this.unresolvedEnvironment = this.createUnresolvedEnvironment();
        }
        return this.unresolvedEnvironment;
    }

    @Override
    public boolean isResolved(EObject eObject) {
        return this.unresolvedEnvironment == null || !this.unresolvedEnvironment.isUnresolved(eObject);
    }

    @Override
    public void postParse() {
        if (this.unresolvedEnvironment != null) {
            ((XMIResource)this.ast).getContents().add((Object)this.unresolvedEnvironment.getUnresolvedEPackage());
        }
    }

    public void saveCST(CSTNode cstNode, URI uri) throws IOException {
        Resource resource = this.getFileEnvironment().getResourceSet().createResource(uri);
        XMIUtils.assignLinearIds((Resource)resource, (String)"cst");
        resource.save(null);
    }

    @Override
    public void validate() {
        if (this.ast == null) {
            return;
        }
        Diagnostician diagnostician = this.createDiagnostician();
        EValidator.SubstitutionLabelProvider substitutionLabelProvider = this.createSubstitutionLabelProvider(diagnostician);
        HashMap<Class, Object> context = new HashMap<Class, Object>();
        context.put(EValidator.SubstitutionLabelProvider.class, substitutionLabelProvider);
        context.put(EValidator.class, diagnostician);
        context.put(ICSTEnvironment.class, this);
        context.put(Environment.class, this);
        ProblemHandlerDiagnosticChain diagnosticChain = this.createDiagnosticChain();
        for (EObject astNode : ((XMIResource)this.ast).getContents()) {
            diagnostician.validate(astNode, (DiagnosticChain)diagnosticChain, context);
        }
    }

    private final class WorkaroundDiagnostician
    extends Diagnostician {
        public WorkaroundDiagnostician() {
            WorkaroundEmfValidator newEmfValidator = new WorkaroundEmfValidator();
            WorkaroundOclValidator newOclValidator = new WorkaroundOclValidator(this, newEmfValidator);
            this.eValidatorRegistry.put((Object)EcorePackage.eINSTANCE, (Object)newEmfValidator);
            this.eValidatorRegistry.put((Object)org.eclipse.ocl.ecore.EcorePackage.eINSTANCE, (Object)newOclValidator);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class WorkaroundEmfValidator
        extends EcoreValidator {
            private WorkaroundEmfValidator() {
            }

            public boolean validateEClassifier_WellFormedInstanceTypeName(EClassifier classifier, DiagnosticChain diagnostics, Map<Object, Object> context) {
                if (classifier instanceof TypeType) {
                    return true;
                }
                return super.validateEClassifier_WellFormedInstanceTypeName(classifier, diagnostics, context);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class WorkaroundOclValidator
        extends org.eclipse.ocl.ecore.util.EcoreValidator {
            final /* synthetic */ WorkaroundDiagnostician this$1;

            public WorkaroundOclValidator(org.eclipse.ocl.examples.parser.environment.CSTRootEnvironment$WorkaroundDiagnostician.WorkaroundEmfValidator emfValidator) {
                this.this$1 = var1_1;
                this.ecoreValidator = emfValidator;
            }
        }
    }
}

